<?php 

if(!function_exists("str_get_html")){
	include "simplehtmldom/simple_html_dom.php";
} 

/* safirBot Class */

class safirBot {
	const FAVICON = "http://www.safirtema.com/favicon.ico";

	public function __construct(){
		$this->eklentiDizin = safirBotDizin;
		
		add_action("admin_menu", array($this, "adminMenu"));  
		add_action("admin_head", array($this, "menuCSS"));  
		add_action("wp_ajax_safirBotAjax", array($this, "ajax"));
	}

	public function adminMenu() {
		add_menu_page("safirBot", "Safir Bot", "edit_others_posts", "safirBot", array($this, "hurriyetBot"), safirBot::FAVICON);
		add_submenu_page("safirBot", "Hürriyet Botu", "Hürriyet Botu", "edit_others_posts", "safirBot", array($this, "hurriyetBot"));
		add_submenu_page("safirBot", "En Son Haber Botu", "En Son Haber Botu", "edit_others_posts", "safirEnSonHaber", array($this, "enSonHaberBot"));
		add_submenu_page("safirBot", "İnternet Haber Botu", "İnternet Haber Botu", "edit_others_posts", "safirInternetHaber", array($this, "internetHaberBot"));
		add_submenu_page("safirBot", "Akşam Botu", "Akşam Botu", "edit_others_posts", "safirAksam", array($this, "aksamBot"));
		add_submenu_page("safirBot", "HaberTürk Botu", "HaberTürk Botu", "edit_others_posts", "safirHaberTurk", array($this, "haberTurkBot"));
		add_submenu_page("safirBot", "HaberTürk Galeri Botu", "HaberTürk Galeri Botu", "edit_others_posts", "safirHaberTurkGaleri", array($this, "haberTurkGaleriBot"));
		add_submenu_page("safirBot", "Sporx Botu", "Sporx Botu", "edit_others_posts", "safirSporx", array($this, "sporxBot"));
		add_submenu_page("safirBot", "Yüksek Topuklar Botu", "Yüksek Topuklar Botu", "edit_others_posts", "safirYuksekTopuk", array($this, "yuksekTopukBot"));
		add_submenu_page("safirBot", "Mahmure Botu", "Mahmure Botu", "edit_others_posts", "safirMahmure", array($this, "mahmureBot"));
	}
	
	public function menuCSS(){
		?>
		<style>.toplevel_page_safirBot .wp-menu-image img{width:16px;height:16px;margin-top:1px;}</style>
		<?php 
	}
	
	public function adminCSS(){
		?>
		<style>
			.toplevel_page_safirBot .wp-menu-image img{width:16px;height:16px;margin-top:1px;}
			.update-nag{display:none;}
			#bot{margin-top:50px;width:98%;}
			#bot ul.children{margin-left:18px;}
			#bot label{padding-bottom:10px;}
			#bot .right {float:right;}
			#bot .ekli{text-decoration:line-through;}
			#bot a{text-decoration:none;}
			#bot .success{color:green;}
			#bot .danger{color:red;}
			#bot .alan1{width:45%;padding-right:20px;float:left;}
			#bot .alan1 input, #bot .alan1 select{width:100%;max-width: 100%}
			#bot .alan2{width:5%;float:right;}
			#bot h3.copy{display:block;width:100%;text-align:right;font-weight:400;font-style:oblique;}
			#bot #message{margin:0;}
			#bot #cevap {overflow:hidden;display:block;width:100%;}
			#bot .botsonuc{margin-right:20px;margin-bottom:20px;}
			#bot .yukleniyor{display:none;clear:both;text-align:center;font-size:18px;margin:50px;padding-top:50px;}
			#bot .haberler{-webkit-appearance: checkbox;-moz-box-sizing: border-box;box-sizing: border-box; width: auto !important;border-radius: 0;}
			#bot form {width:100%;display:block;}
		</style>
		<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css">	
		<script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
		<script type="text/javascript">
			$(document).ready(function() {
				$(document).on("submit", ".icerikform", function(e) { 
					var formObj = $(this);
					var formURL = formObj.attr("action");
					var formData = new FormData(this);
					var id = formObj.find(".button").attr("data-id");
					$(".botsonuc[data-id='" + id + "']").html('<i class="fa fa-spinner fa-spin"></i> Lütfen bekleyiniz.');
						$.ajax({
							url: "<?php echo admin_url("admin-ajax.php"); ?>",
							type: "POST",
							data:  formData,
							mimeType:"multipart/form-data",
							contentType: false,
							cache: false,
							processData:false,
							success: function(data, textStatus, jqXHR){
								$(".botsonuc[data-id='" + id + "']").html(data, textStatus, jqXHR);
								//$("#icerik[data-id='" + id + "']").fadeOut(800);
							}    
						});
					e.preventDefault(); 
				});
				
				$("#ajaxform").submit(function(e){
					var formObj = $(this);
					var formURL = formObj.attr("action");
					var formData = new FormData(this);
					$("#cevap").hide();
					$(".yukleniyor").show();
						$.ajax({
							url: "<?php echo admin_url("admin-ajax.php"); ?>",
							type: "POST",
							data:  formData,
							mimeType:"multipart/form-data",
							contentType: false,
							cache: false,
							processData:false,
							success: function(data, textStatus, jqXHR){
								$(".yukleniyor").hide();
								$("#cevap").show();
								$("#cevap").html(data, textStatus, jqXHR);
								$(".islemalan").hide();
							},
							error: function(jqXHR, textStatus, errorThrown){
								$(".yukleniyor").hide();
							}         
						});
					e.preventDefault(); 
				});
				
				function topluIslem(elements, cb, timeout) {
					var i = 0;
					var l = elements.length;
					$(".islemalan").show();
					$(".tumu").text(l);
					(function fn() {
						cb.call(elements[i++]);
						$(".eklenen").text(i);
						if (i < l) {
							setTimeout(fn, timeout);
						} else {
							$(".durum").text("Eklendi");
							$("#durum").removeClass("fa-spin").removeClass("fa-spinner").addClass("fa-check");
						}
					}());
				}
				
				$(document).on("click", ".tumunuekle", function(e) { 
					$("select[name='taslak']").prop("selectedIndex", 0);
					topluIslem($(".icerikform"), function() {
						$(this).submit();
					}, 500);
					e.preventDefault(); 
				});
				
				$(document).on("click", ".tumunutaslakekle", function(e) { 
					$("select[name='taslak']").prop("selectedIndex", 1);
					topluIslem($(".icerikform"), function() {
						$(this).submit();
					}, 500);
					e.preventDefault(); 
					
				});
				
				var sayfalamaKontrol = $(".sayfalamaKontrol").length;
				
				if(sayfalamaKontrol > 0){
					var sayfalama = $("select[name='kategori']").find("option:selected");

					if(!sayfalama.hasClass("sayfalama")){
						$("input[name='sayfa']").val(1).attr("disabled", "disabled");
					} else {
						$("input[name='sayfa']").removeAttr("disabled");
					}

					$("select[name='kategori']").change(function(){
						var sayfalama = $(this).find("option:selected");
						
						if(!sayfalama.hasClass("sayfalama")){
							$("input[name='sayfa']").val(1).attr("disabled", "disabled");
						} else {
							$("input[name='sayfa']").removeAttr("disabled");
						}
					});
				}
			});
		</script>
		<?php 
	}

	public function ajax(){
		set_time_limit(0);
		
		if($_POST["islem"] == "listele" && $_POST["botID"] == 1){
			$this->hurriyetIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		} elseif($_POST["islem"] == "listele" && $_POST["botID"] == 2){
			$this->enSonHaberIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		} elseif($_POST["islem"] == "listele" && $_POST["botID"] == 3){
			$this->internetHaberIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		} elseif($_POST["islem"] == "listele" && $_POST["botID"] == 4){
			$this->sporxIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		} elseif($_POST["islem"] == "listele" && $_POST["botID"] == 5){
			$this->yuksekTopukIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		} elseif($_POST["islem"] == "listele" && $_POST["botID"] == 6){
			$this->mahmureIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		} elseif($_POST["islem"] == "listele" && $_POST["botID"] == 7){
			$this->haberTurkGaleriIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		} elseif($_POST["islem"] == "listele" && $_POST["botID"] == 8){
			$this->aksamIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		} elseif($_POST["islem"] == "listele" && $_POST["botID"] == 9){
			$this->haberTurkIslem("icerikler", array("url" => base64_decode($_POST["kategori"]), "sayfa" => $_POST["sayfa"]));
			$this->ajaxHTML();
		}elseif($_POST["islem"] == "ekle"){
			$this->icerikEkle($_POST);
		}
		
		die;
	}
	
	public function ajaxHTML(){
		if(empty($this->toplamIcerik)){
			echo "<div id=\"message\" style=\"overflow:hidden;\" class=\"error notice notice-error is-dismissible\"><p>İçerik bulunamadı.</p></div>";
			die;
		}
		?>
		<br>
		<input class="button button-primary button-large tumunuekle" value="Tümünü Yayınla" type="submit">
		<input class="button button-primary button-large tumunutaslakekle" value="Tümünü Taslaklara Ekle" type="submit">
		<br><br>
		
		<table class="wp-list-table widefat fixed striped posts">
			<thead>
				<tr>
					<th scope="col" id="title" class="manage-column column-title sortable desc" colspan="7"><a href="#"><span>İçerik Listesi (<?php echo $this->toplamIcerik; ?>)</span> <span style="float:right;" class="islemalan"><i class="fa fa-spinner fa-spin" id="durum"></i> <c class="durum">Ekleniyor</c> <c class="eklenen">0</c> / <c class="tumu">0</c></span></a></th>
				</tr>
			</thead>

			<tbody id="the-list">
				<?php 
				foreach(end($this->icerikVerileri) as $icerikID => $deger){ 
					$sayi++;
					$wordpressKontrol =  $this->icerikKontrol($this->icerikVerileri["baslik"][$icerikID]);
					if($wordpressKontrol == 0){
				?>
				
				<tr id="icerik" data-id="<?php echo $icerikID; ?>" class="inline-edit-row inline-edit-row-post inline-edit-post quick-edit-row quick-edit-row-post inline-edit-post" >
					<td colspan="7" class="colspanchange">
						<form method="post" class="icerikform">
							<input type="hidden" name="action" value="safirBotAjax" />
							<input type="hidden" name="islem" value="ekle" />
							<input type="hidden" name="botID" value="<?php echo $_POST["botID"]; ?>" />
							<input type="hidden" name="tur" value="<?php echo $this->icerikVerileri["tur"][$icerikID]; ?>" />
							<input type="hidden" name="galeri" value="<?php echo $this->icerikVerileri["galeri"][$icerikID]; ?>" />

							<fieldset class="inline-edit-col-left" style="width:9%;">
								<a href="<?php echo $this->icerikVerileri["url"][$icerikID]; ?>" target="_blank" style="width:100%;display: block;text-align: center;">
									<img style="padding:10px;margin-top:10px;" src="<?php echo $this->icerikVerileri["resim"][$icerikID]; ?>" width="150"/>
								</a>
								<?php if($this->icerikVerileri["tur"][$icerikID] == "galeri"){ ?>
									<center>
										<?php if(!empty($this->icerikVerileri["sayi"][$icerikID])){ ?>
											<b>Resim Sayısı:</b> <?php echo $this->icerikVerileri["sayi"][$icerikID]; ?><br>
										<?php } ?>
										<b>Max. Resim Sayısı:</b> 50
									<center>
								<?php } ?>
							</fieldset>
							
							<fieldset class="inline-edit-col-left" style="width:21%">
								<div class="inline-edit-col">
									<h4>Hızlı Düzenle</h4>
									<label>
										<span class="title">Başlık</span>
										<span class="input-text-wrap"><input type="text" name="baslik" class="ptitle" value="<?php echo str_replace('"', "'", $this->icerikVerileri["baslik"][$icerikID]); ?>" /></span>
									</label>
									<label>
										<span class="title">Resim</span>
										<span class="input-text-wrap"><input type="text" name="resim" value="<?php echo $this->icerikVerileri["resim"][$icerikID]; ?>" /></span>
									</label>

									<div class="inline-edit-group">
										<label>
											<span class="title">Etiketler</span>
											<span class="input-text-wrap"><input type="text" name="etiket" value="<?php echo $this->icerikVerileri["etiket"][$icerikID]; ?>" /></span>
										</label>
										<label>
											<span class="title">Durum</span>
											<span class="input-text-wrap"><select name="taslak"><option value="0">Yayımlanmış</option><option value="1">Taslak</option></select></span>
										</label>
									</div>	
								</div>
							</fieldset>
					
							<fieldset class="inline-edit-col-center inline-edit-categories" style="width:15%">
								<div class="inline-edit-col">
									<span class="title inline-edit-categories-label">Kategoriler</span>
									<ul class="cat-checklist category-checklist" style="height:177px;">
										<?php wp_category_checklist(); ?>
									</ul>
								</div>
							</fieldset>

							<fieldset class="inline-edit-col-right" style="width:48%">
								<?php if($this->icerikVerileri["tur"][$icerikID] != "galeri"){ ?>
									<div class="inline-edit-col">
										<label class="inline-edit-tags">
											<span class="title">Özet</span>
											<textarea cols="22" rows="1" name="ozet" class="tax_input_post_tag"><?php echo $this->icerikVerileri["ozet"][$icerikID]; ?></textarea>
										</label>
							
										<label class="inline-edit-tags">
											<span class="title">İçerik</span>
											<textarea cols="22" rows="1" name="icerik" style="height:73px;" class="tax_input_post_tag"><?php echo $this->icerikVerileri["icerik"][$icerikID]; ?></textarea>
										</label>
									</div>
								<?php } else { ?>
									<div class="inline-edit-col">
										<label class="inline-edit-tags">
											<span class="title">Özet</span>
											<textarea cols="22" rows="1" name="ozet" style="height:178px;" class="tax_input_post_tag"><?php echo $this->icerikVerileri["ozet"][$icerikID]; ?></textarea>
										</label>
									</div>
								<?php } ?>
							</fieldset>

							<p class="submit inline-edit-save">
								<input type="submit" class="button button-primary button-large right" data-id="<?php echo $icerikID; ?>" value="Yayınla" />
								<div class="botsonuc right" data-id="<?php echo $icerikID; ?>" >&nbsp;</div>
							</p>
						</form>
					</td>
				</tr>
				<?php } }  ?>
			</tbody>
		</table>
		<?php
	}
	
	public function hurriyetBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> Hürriyet Botu</h2>
			<?php
				$this->hurriyetIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="1" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select>
				</p>
				<p class="alan1">
					<input type="text" class="sayfalamaKontrol form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	}
	
	public function hurriyetIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			$hurriyetKategoriler = array(
				"http://www.hurriyet.com.tr/gundem/" => "Gündem",
				"http://www.hurriyet.com.tr/ekonomi/" => "Ekonomi",
				"http://www.hurriyet.com.tr/magazin-haberleri/" => "Magazin",
				"http://www.hurriyet.com.tr/spor/" => "Spor",
				"http://www.hurriyet.com.tr/dunya/" => "Dünya",
				"http://www.hurriyet.com.tr/video/ne-oluyor/" => "Video Galeri",
				"http://www.hurriyet.com.tr/foto-galeri/" => "Foto Galeri",
				"http://www.hurriyet.com.tr/teknoloji/" => "Teknoloji",
				"http://www.hurriyet.com.tr/saglik/" => "Sağlık",
				"http://www.hurriyet.com.tr/kultur-sanat/" => "Kültür & Sanat",
			);
			
			$sayfalama = array();
			foreach($hurriyetKategoriler as $kategoriLink => $kategoriAd){
				$kategoriLink = base64_encode($kategoriLink);
				
				if(in_array($kategoriAd, $sayfalama)){
					$this->kategoriler .= "<option class=\"sayfalama\" value=\"$kategoriLink\">$kategoriAd</option>";
				} else {
					$this->kategoriler .= "<option value=\"$kategoriLink\">$kategoriAd</option>";
				}
			}
		} elseif($islemTur == "icerikler") {
			$icerikSay = 0;
			
			if(strpos($veriler["url"], "video/ne-oluyor") === false){
				$html = str_get_html($this->html($veriler["url"]));

				$say = 0;

				foreach($html->find(".main-slider .swiper-slide") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(strpos($icerikURL, "http") !== false && strpos($icerikURL, "hurriyet") === false){
						continue;
					}

					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "http://www.hurriyet.com.tr{$icerikURL}";
					}
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find(".content-wrapper", 0)->plaintext);
						$say++;
					}
				}

				foreach($html->find(".main-category-slider .swiper-slide") as $icerik){
					$icerikURL = $icerik->attr["href"];
					
					if(strpos($icerikURL, "http") !== false && strpos($icerikURL, "hurriyet") === false){
						continue;
					}

					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "http://www.hurriyet.com.tr{$icerikURL}";
					}
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find(".slide-title", 0)->plaintext);
						$say++;
					}
				}

				foreach($html->find(".slider-kelebek-main .swiper-slide") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(strpos($icerikURL, "http") !== false && strpos($icerikURL, "hurriyet") === false){
						continue;
					}

					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "http://www.hurriyet.com.tr{$icerikURL}";
					}
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find(".overlay", 0)->plaintext);
						$say++;
					}
				}

				foreach($html->find("h3.wrap") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(strpos($icerikURL, "http") !== false && strpos($icerikURL, "hurriyet") === false){
						continue;
					}

					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "http://www.hurriyet.com.tr{$icerikURL}";
					}

					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find(".caption", 0)->plaintext);
						$say++;
					}
				}

				foreach($html->find(".main-news-box") as $icerik){
					$icerikURL = $icerik->attr["href"];
					
					if(strpos($icerikURL, "http") !== false && strpos($icerikURL, "hurriyet") === false){
						continue;
					}

					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "http://www.hurriyet.com.tr{$icerikURL}";
					}

					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find("h3", 0)->plaintext);
						$say++;
					}
				}

				foreach($html->find(".content-card") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(strpos($icerikURL, "http") !== false && strpos($icerikURL, "hurriyet") === false){
						continue;
					}

					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "http://www.hurriyet.com.tr{$icerikURL}";
					}

					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find(".content-card-title", 0)->plaintext);
						$say++;
					}
				}

				foreach($html->find(".list-news-list-item") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(strpos($icerikURL, "http") !== false && strpos($icerikURL, "hurriyet") === false){
						continue;
					}

					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "http://www.hurriyet.com.tr{$icerikURL}";
					}

					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find(".list-news-list-title", 0)->plaintext);
						$say++;
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->hurriyetIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						if($icerikVeri["tur"] == "normal"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["icerik"][$say] = $icerikVeri["icerik"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						} elseif($icerikVeri["tur"] == "galeri") {
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
							$icerikler["etiket"][$say] = $icerikVeri["etiket"];
							$icerikler["galeri"][$say] = $icerikVeri["galeri"];
							$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
						}
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			} elseif(strpos($veriler["url"], "video/ne-oluyor") !== false){
				$html = str_get_html($this->html($veriler["url"]));

				$say = 0;
				foreach($html->find(".pg-list .news-feed-item") as $icerik){
					$icerikURL = trim("http://www.hurriyet.com.tr" . $icerik->find("a", 0)->attr["href"]);
					
					if(!array_search($icerikURL, $icerikler["url"]) && strpos($icerikURL, "playlist") === false && !empty($icerikURL)){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = $icerik->find(".news-feed-item-title", 0)->plaintext;
						
						$say++;
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->hurriyetIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			}

			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			$html = str_get_html($veriler["html"]);

			if(strpos($veriler["url"], "video/") === false && strpos($veriler["url"], "fotogaleri.hurriyet.com.tr") === false && strpos($veriler["url"], "galeri-") === false){
				$haber = "";

				if(count($html->find(".news-box")) > 0 ){
					$ozet = trim($html->find(".news-detail-spot", 0)->plaintext);

					foreach($html->find(".news-box p") as $haberVeri){
						$silenecekElementler = array("noscript", ".lazy");
						foreach($silenecekElementler as $element){
							foreach($haberVeri->find("$element") as $item){
								if($element == ".lazy"){
									$item->attr["src"] = $item->attr["data-src"];
								} else {
									$item->outertext = "";
									$item->innertext = "";
								}
							}
						}

						$haberMetin = trim($this->linkTemizle($haberVeri->innertext));
						
						if(!empty($haberMetin)){
							$haber .= "<p>$haberMetin</p>";
						}
					}
				} elseif(count($html->find(".rhd-all-article-detail")) > 0){
					$ozet = trim($html->find(".rhd-article-spot", 0)->plaintext);

					foreach($html->find(".rhd-all-article-detail p") as $haberVeri){
						$silenecekElementler = array("noscript", ".lazy", ".cf");
						foreach($silenecekElementler as $element){
							foreach($haberVeri->find("$element") as $item){
								if($element == ".lazy"){
									$item->attr["src"] = $item->attr["data-src"];
								} else {
									$item->outertext = "";
									$item->innertext = "";
								}
							}
						}

						$haberMetin = trim($this->linkTemizle($haberVeri->innertext));
						
						if(!empty($haberMetin)){
							$haber .= "<p>$haberMetin</p>";
						}
					}
				}

				if(!empty($haber)){
					$haber = preg_replace('~<img.*?data-src="([^"]+).*?\/>~', "<img src='$1' />", $haber);
					
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = trim($haber);
					$icerikVerileri["ozet"] =	$ozet;
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
				}
			} elseif(strpos($veriler["url"], "video/") !== false){
				foreach($html->find('script[type="application/ld+json"]') as $e){
					$json = json_decode($e->innertext, true);

					if(!empty($json["embedUrl"])){
						$videoBilgileri = $json;
					}
				}

				if(empty($videoBilgileri["embedUrl"])){
					preg_match("#embedUrl: '(.*?)'#si", $veriler["html"], $match);

					$videoBilgileri["embedUrl"] = trim(end($match));
				}
				
				$videoEmbed = "<iframe src=\"$videoBilgileri[embedUrl]&resizable=1&autostart=0\" width=\"608px\" height=\"342px\" frameborder=\"0\" scrolling=\"0\" allowfullscreen></iframe>";

				$haber = $videoBilgileri["description"];
				
				if(!empty($videoEmbed)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = "<p>$videoEmbed</p> <p>$haber</p>";
					$icerikVerileri["ozet"]= html_entity_decode($html->find("meta[name='description']", 0)->attr["content"]);
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					$icerikVerileri["etiket"] = html_entity_decode($html->find("meta[name='keywords']", 0)->attr["content"]);
				}
			} elseif(strpos($veriler["url"], "/galeri-") !== false){
				$galeriSayi = $html->find("div[data-count-total]", 0)->attr["data-count-total"];

				$icerikVerileri["tur"] = "galeri";
				$icerikVerileri["ozet"] = trim($this->linkTemizle($html->find(".rhd-article-spot", 0)->innertext));
				$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
				$icerikVerileri["galeri"] = base64_encode(serialize(array("url" => $veriler["url"], "toplam" => $galeriSayi)));
				$icerikVerileri["galeriSayi"] = $galeriSayi;
			}
			
			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			$galeriVeri = unserialize(base64_decode($veriler["veri"]));
			$galeriSayi = $galeriVeri["toplam"];

			if($galeriSayi > 50){
				$galeriSayi = 50;
			}
			
			$galeriUrl[] = $galeriVeri["url"];
			for($say = 2; $say <= $galeriSayi; $say++){
				$galeriUrl[] = "$galeriVeri[url]/$say";
			}
			
			$htmlMulti = $this->htmlMulti($galeriUrl);
			$say = 0;
			foreach($htmlMulti as $galeriHtml){
				$html = str_get_html($galeriHtml);
				$galeriResimler["resim"][$say] = $html->find(".infinitegallery-picture-container .picture img", 0)->attr["data-src"];
				$galeriResimler["aciklama"][$say] = trim($this->linkTemizle($html->find(".infinitegallery-picture-container .text-container", 0)->innertext));
				
				$say++;
			}

			return $galeriResimler;
		}
	}
	
	public function enSonHaberBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> En Son Haber Botu</h2>
			<?php
				$this->enSonHaberIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="2" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select>
				</p>
				<p class="alan1">
					<input type="text" class="sayfalamaKontrol form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	} 

	public function enSonHaberIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			if(!get_transient("safirEnSonHaberKategori")){
				$html = str_get_html($this->html("http://www.ensonhaber.com/"));
				
				$pasifKategoriler = array("Kadın Dünyası", "Video Haber", "oyun");
				foreach($html->find("#menu li") as $kategori){
					$kategoriLink = $kategori->find("a", 0)->attr["href"];
					$kategoriAd = $kategori->find("a", 0)->attr["title"];
					
					if(!in_array($kategoriAd, $pasifKategoriler) && !array_key_exists($kategoriAd, $eklenmisKategoriler)){
						$eklenmisKategoriler[$kategoriAd] = 1;

						if(strpos($kategoriLink, "ensonhaber") === false){
							$kategoriLink = "http://www.ensonhaber.com$kategoriLink";
						}
						
						$kategoriLink = base64_encode($kategoriLink);

						if($kategoriAd != "Spor Haberleri"){
							$this->kategoriler .= "<option class=\"sayfalama\" value=\"$kategoriLink\">$kategoriAd</option>";
						} else {
							$this->kategoriler .= "<option value=\"$kategoriLink\">$kategoriAd</option>";
						}
					}
				}
				
				set_transient("safirEnSonHaberKategori", $this->kategoriler, (3600 * 24));
			} else {
				$this->kategoriler = get_transient("safirEnSonHaberKategori");
			}
		} elseif($islemTur == "icerikler") {
			if(strpos($veriler["url"], "foto-galeri") === false && strpos($veriler["url"], "videonuz") === false && strpos($veriler["url"], "kralspor") === false){
				$html = str_get_html($this->html("$veriler[url]/$veriler[sayfa]"));
				
				$say = 0;
				foreach($html->find(".ui-list li") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = "http://www.ensonhaber.com$icerikURL";
						$icerikler["baslik"][$say] = trim($icerik->find(".ti", 0)->plaintext);
						$say++;
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->enSonHaberIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			} elseif(strpos($veriler["url"], "foto-galeri") !== false){
				$html = str_get_html($this->html("$veriler[url]?sayfa=$veriler[sayfa]"));
				
				$say = 0;
				foreach($html->find(".thumb-list li") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = "http://www.ensonhaber.com$icerikURL";
						$icerikler["baslik"][$say] = trim($icerik->find(".ttl", 0)->plaintext);
						$say++;
					}
				}
				
				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->enSonHaberIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						$icerikler["galeri"][$say] = $icerikVeri["galeri"];
						$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			} elseif(strpos($veriler["url"], "kralspor") !== false){
				$html = str_get_html($this->html($veriler["url"]));
				
				$say = 0;
				foreach($html->find("#headline li") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = "http://kralspor.ensonhaber.com$icerikURL";
						$icerikler["baslik"][$say] = trim($icerik->find("a", 0)->attr["title"]);
						$say++;
					}
				}
				
				foreach($html->find(".ui-list li") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = "http://kralspor.ensonhaber.com$icerikURL";
						$icerikler["baslik"][$say] = trim($icerik->find(".ti", 0)->plaintext);
						$say++;
					}
				}
				
				foreach($html->find(".link-list li") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = "http://kralspor.ensonhaber.com$icerikURL";
						$icerikler["baslik"][$say] = trim($icerik->find(".ttl", 0)->plaintext);
						$say++;
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->enSonHaberIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			} elseif(strpos($veriler["url"], "videonuz") !== false){
				$html = str_get_html($this->html("$veriler[url]/evideolar/$veriler[sayfa]"));
				
				$say = 0;
				
				foreach($html->find(".videoList li") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = "http://videonuz.ensonhaber.com$icerikURL";
						$icerikler["baslik"][$say] = trim($icerik->find(".title", 0)->plaintext);
						$say++;
					}
				}
				
				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->enSonHaberIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			}

			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			$html = str_get_html($veriler["html"]);
			
			if(strpos($veriler["html"], "current_gallery") === false && strpos($veriler["url"], "kralspor") === false && strpos($veriler["url"], "videonuz") === false){
				if(count($html->find(".detail article")) < 1){
					return;
				}

				$silenecekElementler = array("div", "style", "script", "img");
				foreach($silenecekElementler as $element){
					foreach($html->find(".detail", 0)->find("article", 0)->find("$element") as $item){
						if($element == "img"){
							if(strpos($item->attr["src"], "http") === false){
								$resimURL = $item->attr["src"];
								$item->attr["src"] = "http:$resimURL";
							}
						} else {
							$item->outertext = "";
							$item->innertext = "";
						}
					}
				}

				$haber = str_replace(array('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">', "<html>", "<body>", "</body>", "</html>"), "", trim($this->linkTemizle($html->find(".detail", 0)->find("article", 0)->innertext)));
				$resim = $html->find(".detail img", 0)->attr["src"];
				
				if(empty($resim)){
					$resim = $html->find("meta[property='og:image']", 0)->attr["content"];
				}

				if(strpos($resim, "http") === false){
					$resim = "http:$resim";
				}

				if(!empty($haber)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = trim($haber);
					$icerikVerileri["ozet"] = trim($html->find("h2[itemprop='description']", 0)->plaintext);
					$icerikVerileri["resim"] = $resim;
					$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
				}
			} elseif(strpos($veriler["html"], "current_gallery") !== false){
				$say = 0;
				foreach($html->find(".item") as $resim){
					$resimID = $resim->attr["id"];
					
					if(is_numeric($resimID)){
						$galeriResim = $resim->find("img", 0)->attr["src"];
						
						if(empty($galeriResim)){
							$galeriResim = $resim->find("img", 0)->attr["data-original"];
						}

						if(strpos($galeriResim, "http") === false){
							$galeriResim = "http:$galeriResim";
						}
						
						$galeriResimler["resim"][$say] = $galeriResim;
						$galeriResimler["aciklama"][$say] = trim($resim->find(".item-header p", 0)->plaintext);
						
						$say++;
					}
					
					if($say > 49){
						break;
					}
				}
				
				if(is_array($galeriResimler)){
					$icerikVerileri["tur"] = "galeri";
					$icerikVerileri["ozet"] = $html->find("meta[name='description']", 0)->attr["content"];
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
					$icerikVerileri["galeri"] = base64_encode(serialize($galeriResimler));
					$icerikVerileri["galeriSayi"] = $say;
				}
			} elseif(strpos($veriler["url"], "kralspor") !== false){
				$resim = $html->find("#mansetresmi", 0)->attr["src"];
				
				$silenecekElementler = array("#mansetresmi", "div", "img");
				foreach($silenecekElementler as $element){
					foreach($html->find(".detail", 0)->find("article", 0)->find("$element") as $item){
						if($element == "img"){
							if(strpos($item->attr["src"], "../..") !== false){
								$resimURL = $item->attr["src"];
								$item->attr["src"] = str_replace("../..", "http://kralspor.ensonhaber.com", $resimURL);
							}
						} else {
							$item->outertext = "";
							$item->innertext = "";
						}
					}
				}

				$haber = str_replace(array('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">', "<html>", "<body>", "</body>", "</html>"), "", trim($this->linkTemizle($html->find(".detail", 0)->find("article", 0)->innertext)));
				
				if(empty($resim)){
					$resim = $html->find("meta[property='og:image']", 0)->attr["content"];
				}

				if(strpos($resim, "http://kralspor.ensonhaber.com") === false){
					$resim = "http://kralspor.ensonhaber.com" . $resim;
				}
				
				if(!empty($haber)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = trim($haber);
					$icerikVerileri["ozet"] = trim($html->find("h2[itemprop='description']", 0)->plaintext);
					$icerikVerileri["resim"] = $resim;
					$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
				}
			} elseif(strpos($veriler["url"], "videonuz") !== false){
				$videoEmbed = trim($html->find(".videoPlayArea", 0)->innertext);

				if(!empty($videoEmbed)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = "<p>$videoEmbed</p>";
					$icerikVerileri["ozet"] = trim($html->find(".showMore", 0)->plaintext);
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				}
			}

			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			return unserialize(base64_decode($veriler["veri"]));
		}
	}
	
	public function internetHaberBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> İnternet Haber Botu</h2>
			<?php
				$this->internetHaberIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="3" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select> 
				</p>
				<p class="alan1">
					<input type="text" class="sayfalamaKontrol form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	}
	
	public function internetHaberIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			if(!get_transient("safirInternetHaberKategori")){
				$html = str_get_html($this->html("http://www.internethaber.com"));

				$pasifKategoriler = array("Spor", "Oyun", "Burçlar");
				foreach($html->find(".footer-links",0)->find("a") as $kategori){
					$kategoriLink = $kategori->attr["href"];
					$kategoriAd = ucfirst($this->strTo("kucult", trim($kategori->plaintext)));
					
					if(!in_array($kategoriAd, $pasifKategoriler) && !empty($kategoriLink)){
						$kategoriLink = base64_encode("$kategoriLink");
						
						$this->kategoriler .= "<option class=\"sayfalama\" value=\"$kategoriLink\">$kategoriAd</option>";
					}
				}

				$this->kategoriler .= "<option class=\"sayfalama\" value=\"".base64_encode("http://www.internethaber.com/foto-galeri.htm")."\">Foto Galeri</option>";
				$this->kategoriler .= "<option class=\"sayfalama\" value=\"".base64_encode("http://www.internethaber.com/video-galeri.htm")."\">Video Galeri</option>";
			
				set_transient("safirInternetHaberKategori", $this->kategoriler, (3600 * 24));
			} else {
				$this->kategoriler = get_transient("safirInternetHaberKategori");
			}
		} elseif($islemTur == "icerikler") {
			if(strpos($veriler["url"], "foto-galeri") === false && strpos($veriler["url"], "video-galeri") === false){
				$html = str_get_html($this->html("$veriler[url]?page=$veriler[sayfa]"));

				$silinecekElementler = array(".widget-other-news", ".order-md-1", ".aside");

				foreach($silinecekElementler as $element){
					foreach($html->find($element) as $e){
						$e->outertext = "";
					}
				}

				$html->load($html->save());

				$say = 0;

				if(count($html->find("a.news-list")) > 0){
					foreach($html->find(".news-list") as $icerik){
						$class = $icerik->attr["class"];
						$icerikURL = $icerik->attr["href"];

						if(!array_search($icerikURL, $icerikler["url"])){
							$icerikler["url"][$say] = $icerikURL;
							$icerikler["baslik"][$say] = trim($icerik->attr["title"]);
							$say++;
						}
					}
				} else {
					foreach($html->find(".news-list") as $icerik){
						$icerikURL = $icerik->find("a", 0)->attr["href"];

						if(!array_search($icerikURL, $icerikler["url"]) && !is_null($icerikURL) && !empty($icerikURL)){
							$icerikler["url"][$say] = $icerikURL;
							$icerikler["baslik"][$say] = trim($icerik->find("a", 0)->attr["title"]);
							$say++;
						}
					}
				}


				

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->internetHaberIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			} else {
				$html = str_get_html($this->html("$veriler[url]?page=$veriler[sayfa]"));

				$silinecekElementler = array(".widget-other-news", ".order-md-1", ".aside");

				foreach($silinecekElementler as $element){
					foreach($html->find($element) as $e){
						$e->outertext = "";
					}
				}

				$html->load($html->save());

				$say = 0;
				foreach($html->find(".news-list") as $icerik){
					$class = $icerik->attr["class"];
					$icerikURL = $icerik->attr["href"];

					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->attr["title"]);
						$say++;
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->internetHaberIslem("icerikVeri", array("url" => $icerikler["url"][$say], "tur" => $tur, "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						if($icerikVeri["tur"] == "normal"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["icerik"][$say] = $icerikVeri["icerik"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						} elseif($icerikVeri["tur"] == "galeri"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["galeri"][$say] = $icerikVeri["galeri"];
							$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						}
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			}

			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			$html = str_get_html($veriler["html"]);
			
			if(strpos($veriler["url"], "foto-galeri") === false && strpos($veriler["url"], "video-galeri") === false){
				$haber = "";
				
				foreach($html->find(".news-detail-content p") as $haberVeri){
					$haberMetin = trim($this->linkTemizle($haberVeri->innertext));
					
					if(!empty($haberMetin)){
						$haber .= "<p>$haberMetin</p>";
					}
				}
				
				if(!empty($haber)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = trim($haber);
					$icerikVerileri["ozet"] = trim($html->find(".news-detail__description", 0)->plaintext);
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
				}
				
			} elseif(strpos($veriler["url"], "foto-galeri") !== false){
				$toplamResimler = $html->find(".page small", 0)->plaintext;

				$toplamResim = $toplamResimler;
				if($toplamResim > 50){
					$toplamResim = 50;
				}

				$galeriLinkler = array();
				for($say = 1; $say <= $toplamResim; $say++){
					$galeriLinkler[] = "$veriler[url]?page=$say";
				}
				
				$icerikVerileri["tur"] = "galeri";
				$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				$icerikVerileri["ozet"] = trim($html->find(".news-detail__description", 0)->plaintext);
				$icerikVerileri["galeri"] = base64_encode(serialize($galeriLinkler));
				$icerikVerileri["galeriSayi"] = $toplamResimler;
			} elseif(strpos($veriler["url"], "video-galeri") !== false){
				$videoEmbed = trim($html->find(".embed-code textarea", 0)->innertext);  
				$icerik = trim($html->find(".content-text", 0)->plaintext);				
				
				if(!empty($videoEmbed)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = "<p>$videoEmbed</p><p>$icerik</p>";
					$icerikVerileri["ozet"] = trim($html->find(".news-detail__description", 0)->plaintext);
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				}
			}

			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			$galeriLinkler = unserialize(base64_decode($veriler["veri"]));

			$htmlMulti = $this->htmlMulti($galeriLinkler);
			
			$say = 0;
			foreach($htmlMulti as $galeriHtml){
				$html = str_get_html($galeriHtml);

				$galeriResimler["resim"][$say] = $html->find(".infinity-item figure bp-image-component", 0)->attr["lazy-src"];
				$galeriResimler["aciklama"][$say] = trim($html->find(".infinity-item .content-text p", 0)->plaintext);

				$say++;
			}

			return $galeriResimler;
		}
	}
	
	public function aksamBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> Akşam Botu</h2>
			<?php
				$this->aksamIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="8" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select> 
				</p>
				<p class="alan1">
					<input type="text" class="sayfalamaKontrol form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	}
	
	public function aksamIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			$aksamKategoriler = array(
				"http://www.aksam.com.tr/son-dakika/guncel-haberleri/" => "Güncel",
				"http://www.aksam.com.tr/spor/" => "Spor",
				"http://www.aksam.com.tr/magazin/" => "Magazin",
				"http://www.aksam.com.tr/siyaset/" => "Siyaset",
				"http://www.aksam.com.tr/ekonomi/" => "Ekonomi",
				"http://www.aksam.com.tr/yasam/" => "Yaşam",
				"http://www.aksam.com.tr/kobi/" => "Kobi",
				"http://www.aksam.com.tr/dunya/" => "Dünya",
				"http://www.aksam.com.tr/kultur-sanat/" => "Kültür Sanat",
				"http://www.aksam.com.tr/egitim/" => "Eğitim",
				"http://www.aksam.com.tr/televizyon/" => "Televizyon",
				"http://www.aksam.com.tr/moda/" => "Moda",
				"http://www.aksam.com.tr/kadin/" => "Kadın",
				"http://www.aksam.com.tr/otomobil/" => "Otomobil",
				"http://www.aksam.com.tr/teknoloji/" => "Teknoloji",
				"http://www.aksam.com.tr/emlak/" => "Emlak",
				"http://www.aksam.com.tr/doga-hayvan/" => "Doğa Hayvan",
				"http://www.aksam.com.tr/foto-galeri/" => "Foto Galeri",
			);
			
			$sayfalama = array("Video Galeri", "Foto Galeri");
			foreach($aksamKategoriler as $kategoriLink => $kategoriAd){
				$kategoriLink = base64_encode($kategoriLink);
				
				if(in_array($kategoriAd, $sayfalama)){
					$this->kategoriler .= "<option class=\"sayfalama\" value=\"$kategoriLink\">$kategoriAd</option>";
				} else {
					$this->kategoriler .= "<option value=\"$kategoriLink\">$kategoriAd</option>";
				}
			}
		} elseif($islemTur == "icerikler") {
			if(strpos($veriler["url"], "foto-galeri") === false && strpos($veriler["url"], "video-galeri") === false){
				if(strpos($veriler["url"], "guncel-haber") !== false){
					$html = str_get_html(iconv("windows-1254", "UTF-8", $this->html("$veriler[url]")));

					$say = 0;
					
					foreach($html->find(".shaperin1alt2 .photogbox") as $icerik){
						$icerikURL = $icerik->find("a", 0)->attr["href"];
						
						if(!array_search($icerikURL, $icerikler["url"])){
							$icerikler["url"][$say] = $icerikURL;
							$icerikler["baslik"][$say] = trim($icerik->find("a", 0)->attr["title"]);
							$say++;
						}
					}
				} elseif(strpos($veriler["url"], "spor") !== false){
					$html = str_get_html(iconv("windows-1254", "UTF-8", $this->html("$veriler[url]")));

					$say = 0;
					
					if(count($html->find(".slider-1")) > 0){
						foreach($html->find(".slider-1 .swiper-slide") as $icerik){
							$icerikURL = $icerik->find("a", 0)->attr["href"];
							
							if(!array_search($icerikURL, $icerikler["url"])){
								$icerikler["url"][$say] = $icerikURL;
								$icerikler["baslik"][$say] = trim($icerik->find("a", 0)->attr["title"]);
								$say++;
							}
						}
					}
				} elseif(strpos($veriler["url"], "magazin") !== false){
					$html = str_get_html(iconv("windows-1254", "UTF-8", $this->html("$veriler[url]")));

					$say = 0;
					
					if(count($html->find(".main-slider")) > 0){
						foreach($html->find(".main-slider .swiper-slide") as $icerik){
							$icerikURL = $icerik->find("a", 0)->attr["href"];
							
							if(!array_search($icerikURL, $icerikler["url"])){
								$icerikler["url"][$say] = $icerikURL;
								$icerikler["baslik"][$say] = trim($icerik->find("a", 0)->attr["title"]);
								$say++;
							}
						}
					}

					foreach($html->find("div.card-view-1") as $icerik){
						$icerikURL = $icerik->find("a", 0)->attr["href"];
						
						if(!array_search($icerikURL, $icerikler["url"])){
							$icerikler["url"][$say] = $icerikURL;
							$icerikler["baslik"][$say] = trim($icerik->find(".title", 0)->plaintext);
							$say++;
						}
					}
				} else {
					$html = str_get_html(iconv("windows-1254", "UTF-8", $this->html("$veriler[url]")));

					$say = 0;
					
					if(count($html->find("#mainheadline")) > 0){
						foreach($html->find("#mainheadline .swiper-slide") as $icerik){
							$icerikURL = $icerik->find("a", 0)->attr["href"];
							
							if(!array_search($icerikURL, $icerikler["url"])){
								$icerikler["url"][$say] = $icerikURL;
								$icerikler["baslik"][$say] = trim($icerik->find("a", 0)->attr["title"]);
								$say++;
							}
						}
					}

					foreach($html->find("div.news") as $icerik){
						$icerikURL = $icerik->find("a", 0)->attr["href"];
						
						if(!array_search($icerikURL, $icerikler["url"])){
							$icerikler["url"][$say] = $icerikURL;
							$icerikler["baslik"][$say] = trim($icerik->find(".news-headline", 0)->plaintext);
							$say++;
						}
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->aksamIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));

					if(is_array($icerikVeri)){
						$icerikSay++;
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			} elseif(strpos($veriler["url"], "video-galeri") !== false){
				$html = str_get_html(iconv("windows-1254", "UTF-8", $this->html("$veriler[url]?sayfa=$veriler[sayfa]")));

				$say = 0;
				
				foreach($html->find(".videogbox2") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find("h2", 0)->plaintext);
						$say++;
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->aksamIslem("icerikVeri", array("url" => $icerikler["url"][$say], "tur" => $tur, "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						if($icerikVeri["tur"] == "normal"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["icerik"][$say] = $icerikVeri["icerik"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						} elseif($icerikVeri["tur"] == "galeri"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["galeri"][$say] = $icerikVeri["galeri"];
							$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						}
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			} elseif(strpos($veriler["url"], "foto-galeri") !== false){
				$html = str_get_html(iconv("windows-1254", "UTF-8", $this->html("$veriler[url]?sayfa=$veriler[sayfa]")));

				$say = 0;
				
				foreach($html->find(".photogbox") as $icerik){
					$icerikURL = str_replace(array("\n", "\r", "\t", "  "), "", $icerik->find("a", 0)->attr["href"]);
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find("h2", 0)->plaintext);
						$say++;
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;
				foreach($htmlMulti as $html){
					$icerikVeri = $this->aksamIslem("icerikVeri", array("url" => $icerikler["url"][$say], "tur" => $tur, "html" => $html));
					
					if(is_array($icerikVeri)){
						$icerikSay++;
						
						if($icerikVeri["tur"] == "normal"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["icerik"][$say] = $icerikVeri["icerik"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						} elseif($icerikVeri["tur"] == "galeri"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["galeri"][$say] = $icerikVeri["galeri"];
							$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						}
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			}

			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			if(strpos($veriler["url"], "foto-galeri") === false && strpos($veriler["url"], "video/") === false){
				$haber = "";

				if(strpos($veriler["html"], "newsdetailwrap") !== false){
					$html = str_get_html(iconv("windows-1254", "UTF-8", $veriler["html"]));

					foreach($html->find("#textalan p") as $haberVeri){
						$haberMetin = trim($this->linkTemizle($haberVeri->innertext));
						
						if(strpos($haberMetin, "pagination") !== false){
							continue;
						}

						if(!empty($haberMetin)){
							$haber .= "<p>$haberMetin</p>";
						}
					}
					
					if(!empty($haber)){
						$icerikVerileri["tur"] = "normal";
						$icerikVerileri["icerik"] = trim($haber);
						$icerikVerileri["ozet"] = trim($html->find(".newsdetailwrap h2", 0)->plaintext);
						$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					}
				} elseif(strpos($veriler["html"], "news-content") !== false){
					$html = str_get_html(iconv("windows-1254", "UTF-8", $veriler["html"]));

					foreach($html->find(".news-text p") as $haberVeri){
						$haberMetin = trim($this->linkTemizle($haberVeri->innertext));
						
						if(strpos($haberMetin, "pagination") !== false){
							continue;
						}

						if(!empty($haberMetin)){
							$haber .= "<p>$haberMetin</p>";
						}
					}
					
					if(!empty($haber)){
						$icerikVerileri["tur"] = "normal";
						$icerikVerileri["icerik"] = trim($haber);
						$icerikVerileri["ozet"] = trim($html->find(".news-text h2", 0)->plaintext);
						$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					}
				} else {
					unset($icerikVerileri);
				}

				if(strpos($html, "PagedList") !== false){
					unset($icerikVerileri);
				}
			} elseif(strpos($veriler["url"], "foto-galeri") !== false){
				$html = str_get_html(iconv("windows-1254", "UTF-8", $veriler["html"]));

				$toplamResimler = explode(" / ", $html->find(".infinite2 .current-item", 0)->plaintext);

				$toplamResimler = end($toplamResimler);

				$toplamResim = $toplamResimler;

				$galeriID = $html->find(".infinite2", 0)->attr["data-newsid"];

				if($toplamResim > 50){
					$toplamResim = 50;
				}
				
				$galeriLinkler = array();
				for($say = 1; $say <= $toplamResim; $say++){
					$galeriLinkler[] = "http://www.aksam.com.tr/media/cinematic/gallery/default-small.asp?fid=$galeriID&sayfa=$say";
				}
				
				$icerikVerileri["tur"] = "galeri";
				$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				$icerikVerileri["ozet"] = trim($html->find(".infinite2 h2", 0)->plaintext);
				$icerikVerileri["galeri"] = base64_encode(serialize($galeriLinkler));
				$icerikVerileri["galeriSayi"] = $toplamResimler;
			} elseif(strpos($veriler["url"], "video/") !== false){
				$html = str_get_html(iconv("windows-1254", "UTF-8", $veriler["html"]));

				$videoBilgileri = json_decode($html->find('script[type="application/ld+json"]', (count($html->find('script[type="application/ld+json"]')) - 1))->innertext, true);

				$videoEmbed = "<iframe src=\"$videoBilgileri[embedUrl]\" width=\"608px\" height=\"342px\" frameborder=\"0\" scrolling=\"0\" allowfullscreen></iframe>";

				$haber = trim($html->find(".videogtext", 0)->plaintext);
				
				if(!empty($videoEmbed)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = "<p>$videoEmbed</p> <p>$haber</p>";
					$icerikVerileri["ozet"]= html_entity_decode($html->find("meta[name='description']", 0)->attr["content"]);
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					$icerikVerileri["etiket"] = html_entity_decode($html->find("meta[name='keywords']", 0)->attr["content"]);
				}
			}

			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			$galeriLinkler = unserialize(base64_decode($veriler["veri"]));

			$htmlMulti = $this->htmlMulti($galeriLinkler);

			$say = 0;
			foreach($htmlMulti as $galeriHtml){
				$html = str_get_html(iconv("windows-1254", "UTF-8", $galeriHtml));

				$galeriResimler["resim"][$say] = str_replace("#", "", $html->find(".imagearea img", 0)->attr["src"]);
				$galeriResimler["aciklama"][$say] = trim($html->find(".photogtext", 0)->plaintext);

				$say++;
			}

			return $galeriResimler;
		}
	}

	public function haberTurkBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> HaberTürk Botu</h2>
			<?php
				$this->haberTurkIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="9" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select> 
				</p>
				<p class="alan1">
					<input type="text" class="sayfalamaKontrol form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	}
	
	public function haberTurkIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			$haberTurkKategoriler = array(
				"http://www.haberturk.com/gundem" => "Gündem",
				"http://www.haberturk.com/ekonomi" => "Ekonomi",
				"http://www.haberturk.com/spor" => "Spor",
				"http://www.haberturk.com/magazin" => "Magazin",
				"http://www.haberturk.com/dunya" => "Dünya",
				"http://www.haberturk.com/ekonomi/teknoloji" => "Teknoloji",
				"http://www.haberturk.com/saglik" => "Sağlık",
			);
			
			$sayfalama = array();
			foreach($haberTurkKategoriler as $kategoriLink => $kategoriAd){
				$kategoriLink = base64_encode($kategoriLink);
				
				if(in_array($kategoriAd, $sayfalama)){
					$this->kategoriler .= "<option class=\"sayfalama\" value=\"$kategoriLink\">$kategoriAd</option>";
				} else {
					$this->kategoriler .= "<option value=\"$kategoriLink\">$kategoriAd</option>";
				}
			}
		} elseif($islemTur == "icerikler") {
			if(strpos($veriler["url"], "fotogaleri") === false && strpos($veriler["url"], "video") === false){
				$html = str_get_html($this->html("$veriler[url]"));

				$say = 0;
				
				if(count($html->find(".categorySlider")) > 0){
					foreach($html->find(".categorySlider .item") as $icerik){
						$icerikURL = $icerik->find("a", 0)->attr["href"];
						
						if(strpos($icerikURL, "www.haberturk.com") === false){
							$icerikURL = "https://www.haberturk.com{$icerikURL}";
						}

						if(!array_search($icerikURL, $icerikler["url"])){
							$icerikler["url"][$say] = $icerikURL;
							$icerikler["baslik"][$say] = trim($icerik->find("a", 0)->attr["title"]);
							$say++;
						}
					}
				}

				if(count($html->find("#MainSlider")) > 0){
					foreach($html->find("#MainSlider .swiper-slide") as $icerik){
						$icerikURL = $icerik->find("a", 0)->attr["href"];
						
						if(strpos($icerikURL, "www.haberturk.com") === false){
							$icerikURL = "https://www.haberturk.com{$icerikURL}";
						}
						
						if(!array_search($icerikURL, $icerikler["url"])){
							$icerikler["url"][$say] = $icerikURL;
							$icerikler["baslik"][$say] = trim($icerik->find("a", 0)->attr["title"]);
							$say++;
						}
					}
				}

				foreach($html->find(".detail-content div.box-news") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
						
						if(strpos($icerikURL, "www.haberturk.com") === false){
							$icerikURL = "https://www.haberturk.com{$icerikURL}";
						}
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find("h3", 0)->plaintext);
						$say++;
					}
				}

				$htmlMulti = $this->htmlMulti($icerikler["url"]);
				$say = 0;

				foreach($htmlMulti as $html){
					$icerikVeri = $this->haberTurkIslem("icerikVeri", array("url" => $icerikler["url"][$say], "html" => $html));

					if(is_array($icerikVeri)){
						$icerikSay++;

						if($icerikVeri["tur"] == "normal"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["icerik"][$say] = $icerikVeri["icerik"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						} elseif($icerikVeri["tur"] == "galeri"){
							$icerikler["tur"][$say] = $icerikVeri["tur"];
							$icerikler["resim"][$say] = $icerikVeri["resim"];
							$icerikler["galeri"][$say] = $icerikVeri["galeri"];
							$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
							$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						}
					} else {
						unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
					}
					
					$say++;
				}
			}

			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			try {
				$html = str_get_html($veriler["html"]);
				

				if(strpos($veriler["url"], "video/") === false && strpos($veriler["html"], "photo-section") === false){
					$haber = "";
					
					if(count($html->find("article.content p")) > 0){
						foreach($html->find("article.content p") as $haberVeri){
							$haberMetin = trim($this->linkTemizle($haberVeri->innertext));

							if(strpos($haberMetin, "content-related") !== false || strpos($haberMetin, "ads-zone") !== false || strpos($haberMetin, "htplay_") !== false){
								continue;
							}

							if(strpos($haberMetin, "Değerli Haberturk.com okurları") !== false){
								break;
							}
							
							if(!empty($haberMetin) && strpos($haberMetin, "kopyalanamaz ve başka yerde yayınlanamaz.") === false){
								$haber .= "<p>$haberMetin</p>";
							}
						}
					}
					
					$etiketler = array();

					if(count($html->find(".keywords-content a")) > 0){
						foreach($html->find(".keywords-content a") as $etiket){
							$etiketler[] = trim($etiket->plaintext);
						}
					}

					if(!empty($haber)){
						$icerikVerileri["tur"] = "normal";
						$icerikVerileri["icerik"] = trim($haber);
						$icerikVerileri["ozet"] = trim($html->find(".spot-title", 0)->plaintext);
						$icerikVerileri["etiket"] = implode(",", $etiketler);
						$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					}
				} elseif(strpos($veriler["html"], "photo-section") !== false){
					preg_match("#'photoTotalCount': '(.*?)',#si", $veriler["html"], $galeriSayi);

					$galeriSayi = end($galeriSayi);

					if($galeriSayi > 0){
						$icerikVerileri["tur"] = "galeri";
						$icerikVerileri["ozet"] = trim($html->find(".spot-title", 0)->plaintext);
						$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
						$icerikVerileri["galeri"] = base64_encode(serialize(array("url" => $veriler["url"], "toplam" => $galeriSayi)));
						$icerikVerileri["galeriSayi"] = $galeriSayi;
					}
				}
			} catch(Exception $e){

			}

			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			$galeriVeri = unserialize(base64_decode($veriler["veri"]));
			$galeriSayi = $galeriVeri["toplam"];

			if($galeriSayi > 50){
				$galeriSayi = 50;
			}
			
			$galeriUrl[] = $galeriVeri["url"];
			for($say = 2; $say <= $galeriSayi; $say++){
				$galeriUrl[] = "$galeriVeri[url]/$say";
			}

			$htmlMulti = $this->htmlMulti($galeriUrl);
			$say = 0;
			foreach($htmlMulti as $galeriHtml){
				$html = str_get_html($galeriHtml);
				$galeriResimler["resim"][$say] = $html->find(".news-image", 0)->attr["src"];
				$galeriResimler["aciklama"][$say] = trim($this->linkTemizle($html->find(".description", 0)->innertext));
				
				$say++;
			}
			
			return $galeriResimler;
		}
	}
	
	public function sporxBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> Sporx Botu</h2>
			<?php
				$this->sporxIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="4" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select> 
				</p>
				<p class="alan1">
					<input type="text" class="form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	}
	
	public function sporxIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			$sporxKategoriler = array(
				"http://www.sporx.com/ara.php?frm_type=1" => "Haberler",
				"http://www.sporx.com/ara.php?frm_type=2" => "Video Galeri",
				"http://www.sporx.com/ara.php?q=Foto+Galeri&frm_type=3" => "Foto Galeri",
			);
			
			foreach($sporxKategoriler as $kategoriLink => $kategoriAd){
				$kategoriLink = base64_encode($kategoriLink);
				
				$this->kategoriler .= "<option value=\"$kategoriLink\">$kategoriAd</option>";
			}
		} elseif($islemTur == "icerikler") {
			if(strpos($veriler["url"], "frm_type=1") !== false){
				$tur = "haber";
			} elseif(strpos($veriler["url"], "frm_type=2") !== false){
				$tur = "video";
			} elseif(strpos($veriler["url"], "frm_type=3") !== false){
				$tur = "galeri";
			} 
			
			$html = str_get_html($this->html($veriler["url"] . "&frm_page=$veriler[sayfa]"));

			$say = 0;
			foreach($html->find("#searchList li") as $icerik){
				$icerikURL = $icerik->find("a", 0)->attr["href"];
				
				if(strpos($veriler["url"], "frm_type=1") !== false && substr($icerikURL, 0, 5) != "http:"){
					$icerikURL = "http:$icerikURL";
				} elseif(strpos($veriler["url"], "frm_type=3") !== false){
					$icerikURL = "http://www.sporx.com$icerikURL";
				}
				
				if(!empty($icerikURL)){
					$icerikler["url"][$say] = $icerikURL;
					$icerikler["baslik"][$say] = $icerik->find(".sl-title", 0)->plaintext;
					
					$say++;
				}
			}

			$htmlMulti = $this->htmlMulti($icerikler["url"]);
			$say = 0;
			foreach($htmlMulti as $html){
				$icerikVeri = $this->sporxIslem("icerikVeri", array("url" => $icerikler["url"][$say], "tur" => $tur, "html" => $html));
				
				if(is_array($icerikVeri)){
					$icerikSay++;
					
					if($icerikVeri["tur"] == "normal"){
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
					} elseif($icerikVeri["tur"] == "galeri") {
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["galeri"][$say] = $icerikVeri["galeri"];
						$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
					}
				} else {
					unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
				}
				
				$say++;
			}

			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			$html = str_get_html(iconv("windows-1254", "UTF-8", $veriler["html"]));

			if($veriler["tur"] == "haber"){
				if(strpos($veriler["html"], "habericBody") !== false){
					$silenecekElementler = array("div", "script");
					foreach($silenecekElementler as $element){
						foreach($html->find("#habericBody .no-select", 0)->find("$element") as $item){
							$item->outertext = "";
							$item->innertext = "";
						}
					}
					
					$haber = $html->find("#habericBody .no-select", 0)->innertext;
				} elseif(strpos($veriler["html"], "haberbody") !== false){
					foreach($html->find("#haberbody p") as $haberVeri){
						$haberMetin = trim($this->linkTemizle($haberVeri->innertext));
						
						if(!empty($haberMetin)){
							$haber .= "<p>$haberMetin</p>";
						}
					}
				}

				$haber = str_replace('<a href="http://bit.ly/2iqT2Bm" target="_blank" style="color:#DD0000;font-weight:bold;">Sporx mobil uygulamasıyla spor haberlerine herkesten önce ulaşmak için tıklayın</a>', '', $haber);
				
				$resim = $html->find("#haberimg img", 0)->attr["src"];
				
				if(empty($resim)){
					$resim = $html->find("meta[property='og:image']", 0)->attr["content"];
				}
				
				if(!empty($haber)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = trim($haber);
					$icerikVerileri["ozet"] = trim($html->find("#haberheadline", 0)->plaintext);
					$icerikVerileri["resim"] = trim($resim);
				}
			} elseif($veriler["tur"] == "video"){
				if(strpos($veriler["html"], "video-iframe") === false){
					$embedURL = $html->find("meta[itemprop='embedURL']", 0)->attr["content"];
					
					if(!empty($embedURL)){
						$icerikVerileri["tur"] = "normal";
						$icerikVerileri["icerik"] = "<iframe src=\"$embedURL\" width=\"608\" height=\"342\" frameborder=\"0\" scrolling=\"no\" allowfullscreen></iframe>";
						$icerikVerileri["ozet"] = trim($html->find(".vpdesc", 0)->plaintext);
						$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					}
				} elseif(strpos($veriler["html"], "video-iframe") !== false){
					$videoEmbed = trim($html->find(".video-iframe", 0)->innertext);
					
					if(!empty($videoEmbed)){
						$icerikVerileri["tur"] = "normal";
						$icerikVerileri["icerik"] = $videoEmbed;
						$icerikVerileri["ozet"] = trim($html->find(".video-desc", 0)->plaintext);
						$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					}
				}
			} elseif($veriler["tur"] == "galeri"){
				if(strpos($veriler["html"], "story-box") === false){
					preg_match('#src="http://www.sporx.com/_iframe/galeri_cnt.php(.*?)"#si', $veriler["html"], $galeriID);
					parse_str(ltrim($galeriID[1], "?"), $galeriID);
					
					$galeriID = $galeriID["id"];

					$galeriVeri = json_decode($this->html("http://www.sporx.com/_ajax/galeri_load.php", array("id" => $galeriID, "first_load" => 7)), true);

					if(!empty($galeriVeri["count"])){
						$icerikVerileri["tur"] = "galeri";
						$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
						$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
						$icerikVerileri["galeri"] = base64_encode(serialize(array("id" => $galeriID, "toplam" => $galeriVeri["count"])));
						$icerikVerileri["galeriSayi"] = $galeriVeri["count"];
					}
				} else {
					$toplamResimler = $html->find(".story-count", 0)->plaintext;

					$toplamResim = $toplamResimler;
					if($toplamResim > 50){
						$toplamResim = 50;
					}
					
					$galeriLinkler = array();
					for($say = 1; $say <= $toplamResim; $say++){
						$galeriLinkler[] = "$veriler[url]?sira=$say";
					}

					$icerikVerileri["tur"] = "galeri";
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
					$icerikVerileri["ozet"] = trim($html->find("h2#haberdesc", 0)->plaintext);
					$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
					$icerikVerileri["galeri"] = base64_encode(serialize(array("id" => "$veriler[url]?sira=1")));
					$icerikVerileri["galeriSayi"] = $toplamResimler;
				}
			}
			
			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			$galeriVeri = unserialize(base64_decode($veriler["veri"]));
			
			if(is_numeric($galeriVeri["id"])){
				$galeriVeri = json_decode($this->html("http://www.sporx.com/_ajax/galeri_load.php", array("id" => $galeriVeri["id"], "first_load" => $galeriVeri["toplam"])), true);

				$say = 0;
				foreach($galeriVeri["images"] as $resim){
					$galeriResimler["resim"][$say] = $resim["big"];
					$galeriResimler["aciklama"][$say] = trim($resim["headline"]);
					
					$say++;
				}
			} else {
				$html = str_get_html($this->html($galeriVeri["id"]));
				
				$say = 0;
				foreach($html->find(".story-box") as $galeri){
					$galeriResimler["resim"][$say] = $galeri->find(".story-image", 0)->attr["src"];
					$galeriResimler["aciklama"][$say] = trim($galeri->find(".story-desc", 0)->plaintext);
					
					$say++;
				}
			}
			
			return $galeriResimler;
		}
	}
	
	public function yuksekTopukBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> Yüksek Topuklar Botu</h2>
			<?php
				$this->yuksekTopukIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="5" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select>
				</p>
				<p class="alan1">
					<input type="text" class="form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	}

	public function yuksekTopukIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			$yuksekTopukKategoriler = array(
				"https://www.yuksektopuklar.com/kategori/ask-iliskiler" => array("İlişkiler"),
				"https://www.yuksektopuklar.com/kategori/guzellik" => array("Güzellik",
					array(
						"https://www.yuksektopuklar.com/kategori/guzellik/makyaj" => "Makyaj",
						"https://www.yuksektopuklar.com/kategori/guzellik/cilt-bakimi" => "Cilt Bakımı",
						"https://www.yuksektopuklar.com/kategori/guzellik/vucut-bakimi" => "Vücut Bakımı",
						"https://www.yuksektopuklar.com/kategori/guzellik/diyet" => "Diyet",
						"https://www.yuksektopuklar.com/kategori/guzellik/sac" => "Saç"
					)
				),
				"https://www.yuksektopuklar.com/kategori/moda" => array("Moda",
					array(
						"https://www.yuksektopuklar.com/kategori/moda/trendler" => "Trendler",
						"https://www.yuksektopuklar.com/kategori/moda/kombinler" => "Kombinler",
						"https://www.yuksektopuklar.com/kategori/moda/elbise-modelleri" => "Elbise Modelleri",
						"https://www.yuksektopuklar.com/kategori/moda/ayakkabi-modelleri" => "Ayakkabı Modelleri",
						"https://www.yuksektopuklar.com/kategori/moda/koleksiyonlar" => "Koleksiyonlar",
					)
				),
				"https://www.yuksektopuklar.com/kategori/astroloji" => array("Astroloji",
					array(
						"https://www.yuksektopuklar.com/kategori/astroloji/gunluk-burclar" => "Günlük Burçlar",
						"https://www.yuksektopuklar.com/kategori/astroloji/burc-ozellikleri" => "Burç Özellikleri",
						"https://www.yuksektopuklar.com/kategori/astroloji/yildizname-bak" => "Yıldızname Baktır",
						"https://www.yuksektopuklar.com/kategori/astroloji/aylik-burclar" => "Aylık Burçlar",
						"https://www.yuksektopuklar.com/kategori/astroloji/burclara-gore" => "Burçlara Göre",
					)
				),
				"https://www.yuksektopuklar.com/kategori/yemek-tarifleri" => array("Yemek Tarifleri",
					array(
						"https://www.yuksektopuklar.com/kategori/yemek-tarifleri/tatlilar" => "Tatlılar",
						"https://www.yuksektopuklar.com/kategori/yemek-tarifleri/salatalar" => "Salatalar",
						"https://www.yuksektopuklar.com/kategori/yemek-tarifleri/sebze-yemekleri" => "Sebze Yemekleri",
						"https://www.yuksektopuklar.com/kategori/yemek-tarifleri/et-yemekleri" => "Et Yemekleri",
						"https://www.yuksektopuklar.com/kategori/yemek-tarifleri/bes-cayi" => "Beş Çayı"
					)
				),
				"https://www.yuksektopuklar.com/kategori/saglik" => array("Sağlık",
					array(
						"https://www.yuksektopuklar.com/kategori/saglik/kadin-sagligi" => "Kadın Sağlığı",
						"https://www.yuksektopuklar.com/kategori/saglik/beslenme" => "Beslenme",
						"https://www.yuksektopuklar.com/kategori/saglik/psikoloji" => "Psikoloji",
						"https://www.yuksektopuklar.com/kategori/saglik/saglikli-yasam" => "Sağlıklı Yaşam",
						"https://www.yuksektopuklar.com/kategori/saglik/spor" => "Spor"
					)
				),
				"https://www.yuksektopuklar.com/kategori/aktuel" => array("Aktüel"),
				"https://www.yuksektopuklar.com/kategori/anne-bebek" => array("Anne Bebek",
					array(
						"https://www.yuksektopuklar.com/kategori/anne-bebek/hamilelik" => "Hamilelik",
						"https://www.yuksektopuklar.com/kategori/anne-bebek/bebek-bakimi" => "Bebek Bakımı",
						"https://www.yuksektopuklar.com/kategori/anne-bebek/anne-olmak" => "Anne Olmak",
						"https://www.yuksektopuklar.com/kategori/anne-bebek/bebek-isimleri" => "Bebek İsimleri",
						"https://www.yuksektopuklar.com/kategori/anne-bebek/cocuk-gelisimi" => "Çocuk Gelişimi"
					)
				),
			);
			
			foreach($yuksekTopukKategoriler as $id => $kategori){
				if(is_array($kategori)){
					$kategoriID = base64_encode($id);
					$kategoriAd = trim($kategori[0]);
					
					$this->kategoriler .= "<option value=\"$kategoriID\">$kategoriAd</option>";
				
					foreach($kategori[1] as $altID => $altKategori){
						$kategoriAltID = base64_encode($altID);
						$altKategori = trim($altKategori);
						
						$this->kategoriler .= "<option value=\"$kategoriAltID\">--- $altKategori</option>";
					}
				} else {
					$kategoriID = base64_encode($id);
					$kategoriAd = trim($kategori[0]);
					
					$this->kategoriler .= "<option value=\"$kategoriID\">$kategoriAd</option>";
				}
			}
			
			
		} elseif($islemTur == "icerikler") {
			if($veriler["sayfa"] == 1){
				$html = str_get_html($this->html("$veriler[url]"));
			} else {
				$html = str_get_html($this->html("$veriler[url]/page/$veriler[sayfa]"));
			}
				
			$say = 0;	
			foreach($html->find("article.post-list") as $icerik){
				$icerikURL = $icerik->find(".post-title a", 0)->attr["href"];

				if(!array_search($icerikURL, $icerikler["url"])){
					$icerikler["url"][$say] = $icerikURL;
					$icerikler["baslik"][$say] = trim($icerik->find(".post-title", 0)->plaintext);
					$say++;
				}
			}
			
			$htmlMulti = $this->htmlMulti($icerikler["url"]);
			$say = 0;
			foreach($htmlMulti as $html){
				$icerikVeri = $this->yuksekTopukIslem("icerikVeri", array("url" => $icerikler["url"][$say], "tur" => $tur, "html" => $html));
				
				if(is_array($icerikVeri)){
					$icerikSay++;
					
					if($icerikVeri["tur"] == "normal"){
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
					} elseif($icerikVeri["tur"] == "galeri") {
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["ozet"][$say] = $icerikVeri["ozet"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						$icerikler["galeri"][$say] = $icerikVeri["galeri"];
						$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
					}
				} else {
					unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
				}
				
				$say++;
			}
			
			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			$html = str_get_html($veriler["html"]);
			
			$etiketler = array();

			if(strpos($veriler["html"], 'class="single-page-links') === false){
				$silinecekElementler = array("div", "section"," script", "img");
				foreach($silinecekElementler as $element){
					foreach($html->find("div[itemprop='articleBody']", 0)->find("$element") as $item){
						if($element != "img" && $element != "div"){
							$item->outertext = "";
							$item->innertext = "";
						} elseif($element == "div" && strpos($item->attr["class"], "video") === false){
							$item->outertext = "";
							$item->innertext = "";
						} else {
							$item->removeAttribute("class");
							$item->removeAttribute("srcset");
							$item->removeAttribute("sizes");
						}
					}
				}
				
				$haber = str_replace(array("</div> .post-content", "[if lt IE 9]><script>document.createElement('video');</script><![endif]", "<!--", "-->"), "", $html->find("div[itemprop='articleBody']", 0)->innertext);
				
				foreach($html->find("meta[property='article:tag']") as $etiket){
					$etiketler[] = $etiket->attr["content"];
				}

				if(!empty($haber)){
					$icerikVerileri["tur"] = "normal";
					$icerikVerileri["icerik"] = trim($this->linkTemizle($haber));
					$icerikVerileri["ozet"] = $html->find("meta[property='og:description']", 0)->attr["content"];
					$icerikVerileri["etiket"] = implode(",", $etiketler);
					$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				}
			} else {
				foreach($html->find("meta[property='article:tag']") as $etiket){
					$etiketler[] = $etiket->attr["content"];
				}

				$icerikVerileri["tur"] = "galeri";
				$icerikVerileri["ozet"] = $html->find("meta[property='og:description']", 0)->attr["content"];
				$icerikVerileri["etiket"] = implode(",", $etiketler);
				$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				$icerikVerileri["galeri"] = base64_encode($veriler["url"]);
			}
			
			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			$galeriURL = base64_decode($veriler["veri"]);

			for($say = 1; $say <= 50; $say++){
				$htmlSafe = $this->html("$galeriURL/$say");
				$html = str_get_html($htmlSafe);
				
				$toplamSayfa = count($html->find(".pagination-num .page-numbers"));

				$silinecekElementler = array("div", "section"," script");
				foreach($silinecekElementler as $element){
					foreach($html->find(".smart_content_wrapper", 0)->find("$element") as $item){
						$item->outertext = "";
						$item->innertext = "";
					}
				}

				$galeriResimler["resim"][$say] = $html->find("img.size-full", 0)->attr["src"];
				$galeriResimler["aciklama"][$say] = trim($html->find(".smart_content_wrapper", 0)->plaintext);
				
				if($toplamSayfa == $say){
					break;
				}
			}

			return $galeriResimler;
		}
	}
	
	public function mahmureBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> Mahmure Botu</h2>
			<?php
				$this->mahmureIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="6" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select>
				</p>
				<p class="alan1">
					<input type="text" class="sayfalamaKontrol form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	}
	
	public function mahmureIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			$mahmureKategoriler = array(
				"moda" => array("Moda"),
				"guzellik-bakim" => array("Güzellik"),
				"ask-iliskiler" => array("Aşk & İlişkiler"),
				"eglence" => array("Eğlence"),
				"saglikli-yasam" => array("Yaşam"),
			);
			
			foreach($mahmureKategoriler as $id => $kategori){
				if(is_array($kategori)){
					$kategoriID = base64_encode($id);
					$kategoriAd = trim($kategori[0]);
					
					$this->kategoriler .= "<option value=\"$kategoriID\">$kategoriAd</option>";
				
					foreach($kategori[1] as $altID => $altKategori){
						$kategoriAltID = base64_encode($altID);
						$altKategori = trim($altKategori);
						
						$this->kategoriler .= "<option value=\"$kategoriAltID\">--- $altKategori</option>";
					}
				} else {
					$kategoriID = base64_encode($id);
					$kategoriAd = trim($kategori[0]);
					
					$this->kategoriler .= "<option value=\"$kategoriID\">$kategoriAd</option>";
				}
			}
		} elseif($islemTur == "icerikler") {
			$sourceHTML = str_get_html($this->html("http://www.hurriyet.com.tr/mahmure/$veriler[url]"));
			$sourceID = $sourceHTML->find("div[data-datasource-id]", 0)->attr["data-datasource-id"];


			/*
			$say = 0;
			if(count($html->find("#mainSlider")) > 0){
				foreach($html->find("#mainSlider .swiper-slide") as $icerik){
					$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "https://www.hurriyet.com.tr{$icerikURL}";
					}
					
					if(!array_search($icerikURL, $icerikler["url"])){
						$icerikler["url"][$say] = $icerikURL;
						$icerikler["baslik"][$say] = trim($icerik->find(".main-slider-main-title", 0)->plaintext);
						$say++;
					}
				}
			}

			foreach($html->find(".newscard-list-item") as $icerik){
				$icerikURL = $icerik->find("a", 0)->attr["href"];
					
					if(strpos($icerikURL, "www.hurriyet.com.tr") === false){
						$icerikURL = "https://www.hurriyet.com.tr{$icerikURL}";
					}
				
				if(!array_search($icerikURL, $icerikler["url"])){
					$icerikler["url"][$say] = $icerikURL;
					$icerikler["baslik"][$say] = trim($icerik->find(".news-card-title", 0)->plaintext);
					$say++;
				}
			}*/

			$json = json_decode($this->html("http://www.hurriyet.com.tr/api/datasource/getpageddatasource?sourceId=$sourceID&take=40"));

			$say = 0;
			foreach($json->Contents as $list){
				$icerikler["url"][$say] = $list->Url;
				$icerikler["baslik"][$say] = $list->Title;
				$icerikler["ozet"][$say] = $list->Spot;

				$say++;
			}
			
			$htmlMulti = $this->htmlMulti($icerikler["url"]);
			$say = 0;
			foreach($htmlMulti as $html){
				$icerikVeri = $this->mahmureIslem("icerikVeri", array("url" => $icerikler["url"][$say], "tur" => $icerikler["tur"][$say], "html" => $html));
				
				if(is_array($icerikVeri)){
					$icerikSay++;
					
					if($icerikVeri["tur"] == "normal"){
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["icerik"][$say] = $icerikVeri["icerik"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
					} elseif($icerikVeri["tur"] == "galeri") {
						$icerikler["tur"][$say] = $icerikVeri["tur"];
						$icerikler["resim"][$say] = $icerikVeri["resim"];
						$icerikler["etiket"][$say] = $icerikVeri["etiket"];
						$icerikler["galeri"][$say] = $icerikVeri["galeri"];
						$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
					}
				} else {
					unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
				}
				
				$say++;
			}

			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			$html = str_get_html($veriler["html"]);
			
			if(strpos($veriler["html"], "gallery-main-container") !== false){
				$galeriSayi = $html->find("div[data-count-total]", 0)->attr["data-count-total"];

				$icerikVerileri["tur"] = "galeri";
				$icerikVerileri["ozet"] = trim($this->linkTemizle($html->find(".rhd-article-spot", 0)->innertext));
				$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
				$icerikVerileri["galeri"] = base64_encode(serialize(array("url" => $veriler["url"], "toplam" => $galeriSayi)));
				$icerikVerileri["galeriSayi"] = $galeriSayi;
			} else {
				$icerikVerileri["tur"] = "normal";
				$icerikVerileri["ozet"] = trim($this->linkTemizle($html->find(".rhd-article-spot-type-mahmure", 0)->innertext));
				$icerikVerileri["icerik"] = trim($this->linkTemizle($html->find(".rhd-all-article-detail", 0)->innertext));
				$icerikVerileri["resim"] = $html->find("meta[property='og:image']", 0)->attr["content"];
				$icerikVerileri["etiket"] = $html->find("meta[name='keywords']", 0)->attr["content"];
			}

			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			$galeriVeri = unserialize(base64_decode($veriler["veri"]));
			$galeriSayi = $galeriVeri["toplam"];

			if($galeriSayi > 50){
				$galeriSayi = 50;
			}
			
			$galeriUrl[] = $galeriVeri["url"];
			for($say = 2; $say <= $galeriSayi; $say++){
				$galeriUrl[] = "$galeriVeri[url]/$say";
			}
			
			$htmlMulti = $this->htmlMulti($galeriUrl);
			$say = 0;
			foreach($htmlMulti as $galeriHtml){
				$html = str_get_html($galeriHtml);
				$galeriResimler["resim"][$say] = $html->find(".infinitegallery-picture-container .picture img", 0)->attr["data-src"];
				$galeriResimler["aciklama"][$say] = trim($this->linkTemizle($html->find(".infinitegallery-picture-container .text-container", 0)->innertext));
				
				$say++;
			}
			
			return $galeriResimler;
		}
	}
	
	public function haberTurkGaleriBot(){
		error_reporting(0);
		$this->adminCSS();
	?>
		<div id="bot">
			<h2><i class="fa fa-newspaper-o"></i> HaberTürk Galeri Botu</h2>
			<?php
				$this->haberTurkGaleriIslem("kategori"); 
			?>
			<form method="post" id="ajaxform">
				<input type="hidden" name="action" value="safirBotAjax" />
				<input type="hidden" name="botID" value="7" />
				<input type="hidden" name="islem" value="listele" />
				<p class="alan1">
					<select name="kategori" id="bulk-action-selector-top">
						<?php echo $this->kategoriler; ?>
					</select>
				</p>
				<p class="alan1">
					<input type="text" class="form-control" name="sayfa" value="1" />
				</p>
				<p class="alan2"><input type="submit" class="button button-primary button-large right" value="Listele" /></p>
			</form>
			<div class="yukleniyor"><i class="fa fa-spinner fa-spin"></i> </br> </br> Lütfen bekleyiniz...</div>
			<div id="cevap"></div>
			<h3 class="copy"><a href="http://www.doii.net">Eftal Bulut</a></h3>
		</div>
	<?php
	}
	
	public function haberTurkGaleriIslem($islemTur, $veriler = false){
		if($islemTur == "kategori"){
			$html = str_get_html($this->html("http://www.haberturk.com/galeri"));
			
			foreach($html->find("header .selected div.sub-category li") as $kategori){
				$kategoriLink = base64_encode("http://www.haberturk.com" . $kategori->find("a", 0)->attr["href"]);
				$kategoriAd = ucfirst($this->strTo("kucult", trim($kategori->plaintext)));
				
				$this->kategoriler .= "<option value=\"$kategoriLink\">$kategoriAd</option>";
			}
		} elseif($islemTur == "icerikler") {
			if($veriler["sayfa"] == 1){
				$html = $this->html($veriler["url"]);
			} else {
				$ajaxLoad = array(
					"/galeri/gundem" => "/galeri/home/ajaxload/110?page=$veriler[sayfa]",
					"/galeri/ekonomi" => "/galeri/home/ajaxload/130?page=$veriler[sayfa]",
					"/galeri/spor" => "/galeri/home/ajaxload/170?page=$veriler[sayfa]",
					"/galeri/komedi" => "/galeri/home/ajaxload/360?page=$veriler[sayfa]",
					"/galeri/magazin" => "/galeri/home/ajaxload/9?page=$veriler[sayfa]",
					"/galeri/yasam" => "/galeri/home/ajaxload/7?page=$veriler[sayfa]",
					"/galeri/seyahat" => "/galeri/home/ajaxload/8?page=$veriler[sayfa]",
					"/galeri/teknoloji" => "/galeri/home/ajaxload/10?page=$veriler[sayfa]",
					"/galeri/diger" => "/galeri/home/ajaxload/350?page=$veriler[sayfa]",
				);
				
				$kategori = trim(str_replace("http://www.haberturk.com", "", $veriler["url"]));
				$html = $this->html("http://www.haberturk.com" . $ajaxLoad[$kategori]);
			}
			
			$html = str_get_html($html);
			
			$say = 0;
			foreach($html->find(".item") as $galeri){
				$icerikler["url"][$say] = "http://www.haberturk.com" . $galeri->find("a", 0)->attr["href"];
				$icerikler["baslik"][$say] = $galeri->find("a", 0)->attr["title"];
				
				$say++;
			}

			$htmlMulti = $this->htmlMulti($icerikler["url"]);
			$say = 0;
			foreach($htmlMulti as $html){
				$icerikVeri = $this->haberTurkGaleriIslem("icerikVeri", array("url" => $icerikler["url"][$say], "tur" => $icerikler["tur"][$say], "html" => $html));
				
				if(is_array($icerikVeri)){
					$icerikSay++;

					$icerikler["tur"][$say] = $icerikVeri["tur"];
					$icerikler["ozet"][$say] = $icerikVeri["ozet"];
					$icerikler["resim"][$say] = $icerikVeri["resim"];
					$icerikler["etiket"][$say] = $icerikVeri["etiket"];
					$icerikler["galeri"][$say] = $icerikVeri["galeri"];
					$icerikler["sayi"][$say] = $icerikVeri["galeriSayi"];
				} else {
					unset($icerikler["url"][$say], $icerikler["baslik"][$say], $icerikler["icerik"][$say], $icerikler["ozet"][$say], $icerikler["resim"][$say], $icerikler["etiket"][$say], $icerikler["galeri"][$say], $icerikler["sayi"][$say]);
				}
				
				$say++;
			}

			$this->toplamIcerik = $icerikSay;
			$this->icerikVerileri = array("tur" => $icerikler["tur"], "baslik" => $icerikler["baslik"], "resim" => $icerikler["resim"],"etiket" => $icerikler["etiket"],"ozet" => $icerikler["ozet"],"icerik" => $icerikler["icerik"],"galeri" => $icerikler["galeri"],"sayi" => $icerikler["sayi"],"url" => $icerikler["url"]);
		} elseif($islemTur == "icerikVeri"){
			$html = str_get_html($veriler["html"]);
			
			preg_match("#images = (.*?)\n#si", $veriler["html"], $resimler);

			$resimler[1] = rtrim(trim($resimler[1]), ",");
			$resimler = json_decode($resimler[1], true);

			$galeriSayi = count($resimler);
			
			if($galeriSayi > 0){
				$silinecekElementler = array("div",);
				foreach($silinecekElementler as $element){
					foreach($html->find(".gallery-right .spot", 0)->find("$element") as $item){
						$item->outertext = "";
						$item->innertext = "";
					}
				}

				preg_match('#"keywords":"(.*?)"#si', $veriler["html"], $etiketler);

				$icerikVerileri["tur"] = "galeri";
				$icerikVerileri["ozet"] = trim($html->find(".gallery-right .spot", 0)->plaintext);
				$icerikVerileri["resim"] = $html->find(".carousel-item img", 0)->attr["src"];
				$icerikVerileri["etiket"] = json_decode('"'. trim(end($etiketler)) .'"');
				$icerikVerileri["galeri"] = base64_encode(serialize(array("resimler" => $resimler)));
				$icerikVerileri["galeriSayi"] = $galeriSayi;
			}

			return $icerikVerileri;
		} elseif($islemTur == "galeriVeri"){
			$galeriVeri = unserialize(base64_decode($veriler["veri"]));

			$say = 0;
			foreach($galeriVeri["resimler"] as $resim){
				if($say > 49){
					break;
				}

				$galeriResimler["resim"][$say] = $resim["image"];
				$galeriResimler["aciklama"][$say] = trim($resim["description"]);

				$say++;
			}
			
			return $galeriResimler;
		}
	}

	public function icerikEkle($veriler){
		$icerik["baslik"] = $veriler["baslik"];
		$icerik["resim"] = $veriler["resim"];
		$icerik["etiket"] = $veriler["etiket"];
		$icerik["taslak"] = $veriler["taslak"];
		$icerik["kategori"] = $veriler["post_category"];
		$icerik["icerik"] = stripslashes($veriler["icerik"]);
		$icerik["ozet"] = $veriler["ozet"];
		$icerik["botID"] = $veriler["botID"];
		$icerik["tur"] = $veriler["tur"];
		$icerik["galeri"] = $veriler["galeri"];
		
		$wordpressKontrol =  $this->icerikKontrol($icerik["baslik"]);
		
		if($wordpressKontrol == 0){
			if($icerik["tur"] != "galeri"){
				$icerikHtml = str_get_html($icerik["icerik"]);
			
				foreach($icerikHtml->find("img") as $res){
					$resim = $res->attr["src"];
					$resimYukle = $this->resimYukle($icerik["baslik"], $resim);
					$icerik["icerik"] = str_replace($resim, $resimYukle, $icerik["icerik"]);
				}
			} else {
				if($icerik["botID"] == 1){
					$galeriResimler = $this->hurriyetIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				} elseif($icerik["botID"] == 2){
					$galeriResimler = $this->enSonHaberIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				} elseif($icerik["botID"] == 3){
					$galeriResimler = $this->internetHaberIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				} elseif($icerik["botID"] == 4){
					$galeriResimler = $this->sporxIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				} elseif($icerik["botID"] == 5){
					$galeriResimler = $this->yuksekTopukIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				} elseif($icerik["botID"] == 6){
					$galeriResimler = $this->mahmureIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				} elseif($icerik["botID"] == 7){
					$galeriResimler = $this->haberTurkGaleriIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				} elseif($icerik["botID"] == 8){
					$galeriResimler = $this->aksamIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				} elseif($icerik["botID"] == 9){
					$galeriResimler = $this->haberTurkIslem("galeriVeri", array("veri" => $icerik["galeri"]));
				}
			}

			$icerikEkle = array();
			$icerikEkle["post_title"] = $icerik["baslik"];
			
			if($icerik["taslak"] == 1){
				$icerikEkle["post_status"] = "draft";
			} else {
				$icerikEkle["post_status"] = "publish";
			}
			
			$icerikEkle["post_author"] = 1;
			$icerikEkle["post_type"] = "post";
			$icerikEkle["post_category"] = $icerik["kategori"];
			
			if($icerik["tur"] != "galeri"){
				$icerikEkle["post_content"] = $icerik["icerik"];
			}
			
			if(!empty($icerik["ozet"])){
				$icerikEkle["post_excerpt"] = $icerik["ozet"];
			}
			
			if(!empty($icerik["etiket"])){
				$icerikEkle["tags_input"] = $icerik["etiket"];
			}
		
			$wordpressEkle = wp_insert_post($icerikEkle);

			if($wordpressEkle != 0){
				if(!empty($icerik["resim"])){
					$this->oneCikan($icerik["baslik"], $icerik["resim"], $wordpressEkle);
				}
				
				if($icerik["tur"] == "galeri" && is_array($galeriResimler)){
					$this->galeriYukle($galeriResimler, $icerik["baslik"], $wordpressEkle);
				}
				
				add_post_meta($wordpressEkle, "_aioseop_title", $icerik["baslik"]);
				add_post_meta($wordpressEkle, "_aioseop_keywords", $icerik["etiket"]);
				
				echo "<span class=\"success\"><i class=\"fa fa-check\"></i> İçerik başarıyla eklendi.</span>";
			} else {
				echo "<span class=\"danger\"><i class=\"fa fa-times\"></i> İçerik eklenirken hata oluştu.</span>";
			}
		} else {
			echo "<span class=\"danger\"><i class='fa fa-times\"></i> İçerik zaten eklenmiş.</span>";
		}	
	}
	
	public function galeriYukle($resimVerileri, $baslik, $yaziID) {
		$say = 0;
		foreach($resimVerileri["resim"] as $resimURL){
			$resimAdi = sanitize_title($baslik) . "-$say.jpg";

			$resimYukle = wp_upload_bits($resimAdi, "image/jpeg", $this->html($resimURL));
			
			if(!empty($resimYukle["error"])) {
				return $resimYukle["error"];
			} else {
				$resimDosya  = $resimYukle["file"];
				$ortamDosyasi = array("guid" => $resimYukle["url"], "post_mime_type" => "image/jpeg", "post_title" => $baslik, "post_content" => (string) $resimVerileri["aciklama"][$say]);
				$ortamID  = wp_insert_attachment($ortamDosyasi, $resimDosya, $yaziID);
				$ortamVeri  = wp_generate_attachment_metadata($ortamID, $resimDosya);
				wp_update_attachment_metadata($ortamID, $ortamVeri);
				$galeriID[] = $ortamID;
			}
			
			$say++;
		}
		
		$galeriCikti = implode(",", $galeriID);
		$galeriCikti = "[gallery ids=\"$galeriCikti\"]";
		
		$galeriGuncelle = array();
		$galeriGuncelle["ID"] = $yaziID;
		$galeriGuncelle["post_content"] = $galeriCikti;
		wp_update_post($galeriGuncelle);
	}
	
	public function resimYukle($resimBaslik, $resimURL) {
		$dosyaAdi = sanitize_title(remove_accents($resimBaslik));
		$dosyaAdi = "$dosyaAdi.jpg";

		$resimYukle = wp_upload_bits($dosyaAdi, "image/jpeg", $this->html($resimURL));

		return $resimYukle["url"];
	}
	
	public function oneCikan($resimBaslik, $resimURL, $yaziID) {
		$dosyaAdi = sanitize_title(remove_accents($resimBaslik));
		$dosyaAdi = "$dosyaAdi.jpg";
		
		$resimYukle = wp_upload_bits($dosyaAdi, "image/jpeg", $this->html($resimURL));
		
		if(!empty($resimYukle["error"])) {
			return $resimYukle["error"];
		} else {
			$yuklenenResim = $resimYukle["file"];
			$eklenti = array("guid" => $resimYukle["url"], "post_mime_type" => "image/jpeg", "post_title" => $resimBaslik, "post_content" => "");
			$eklentiID = wp_insert_attachment($eklenti, $yuklenenResim, $yaziID);
			$eklentiVeri = wp_generate_attachment_metadata($eklentiID, $yuklenenResim);
			wp_update_attachment_metadata($eklentiID, $eklentiVeri);
			add_post_meta($yaziID, "_thumbnail_id", $eklentiID, true);
		}
	}
	
	public function linkTemizle($veri){
		preg_match_all("/<a (.*)<\/a>/isU", $veri, $sonuc);
		
		foreach($sonuc[0] as $rs){
			$veri = str_replace($rs, preg_replace("/<a (.*)>(.*)<\/a>/isU", '$2', $rs), $veri);
		}
		
		return $veri;
	}
	
	public function strTo($islem, $metin) {
		if($islem == "kucult") {
			return mb_strtolower(str_replace(array("I", "Ğ", "Ü", "Ş", "İ", "Ö", "Ç"), array("ı", "ğ", "ü", "ş", "i", "ö", "ç"), $metin), "utf-8");
		} elseif ($islem == "buyult") {
			return mb_strtoupper(str_replace(array("ı", "ğ", "ü", "ş", "i", "ö", "ç"), array("I", "Ğ", "Ü", "Ş", "İ", "Ö", "Ç"), $metin), "utf-8");
		}
	}
	
	public function icerikKontrol($baslik){
		global $wpdb;
		
		$wordpressKontrol = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM wp_posts WHERE post_title = '%s' AND post_type='post'", array($baslik)));
		return $wordpressKontrol;
	}

	public function html($url, $postVeriler = false, $headerVeriler = false) {
		$ct = curl_init();
		curl_setopt($ct, CURLOPT_URL, $url);
		curl_setopt($ct, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ct, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ct, CURLOPT_TIMEOUT, 0);
		curl_setopt($ct, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($ct, CURLOPT_USERAGENT, "Googlebot/2.1 (http://www.googlebot.com/bot.html)");
		curl_setopt($ct, CURLOPT_REFERER, "http://www.google.com/bot.html");
		curl_setopt($ct, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ct, CURLOPT_SSL_VERIFYPEER, 0);
		
		if($postVeriler){
			curl_setopt($ct, CURLOPT_POST, true);
			
			if(is_array($postVeriler)){
				curl_setopt($ct, CURLOPT_POSTFIELDS, $postVeriler);
			}
		}
		
		if(is_array($headerVeriler)){
			curl_setopt($ct, CURLOPT_HTTPHEADER, $headerVeriler);
		}
		
		$cikti = curl_exec($ct);
		curl_close($ct);
		return $cikti;
	}
	
	public function htmlMulti($urls){
		foreach ($urls as $url) {
            $ct = curl_init();
            curl_setopt($ct, CURLOPT_URL, $url);
            curl_setopt($ct, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ct, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ct, CURLOPT_TIMEOUT, 0);
			curl_setopt($ct, CURLOPT_CONNECTTIMEOUT, 0);
			curl_setopt($ct, CURLOPT_USERAGENT, "Googlebot/2.1 (http://www.googlebot.com/bot.html)");
			curl_setopt($ct, CURLOPT_REFERER, "http://www.google.com/bot.html");
			curl_setopt($ct, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ct, CURLOPT_SSL_VERIFYPEER, 0);
            $Curl[] = $ct;
        }
		
		$MultiCurlHandler = curl_multi_init();
		
		foreach($Curl as $key => $curl){
            curl_multi_add_handle($MultiCurlHandler, $curl);
        }
        
		do {
            $MultiCurl = curl_multi_exec($MultiCurlHandler, $active);
        } 
		while ($MultiCurl == CURLM_CALL_MULTI_PERFORM  || $active);
		
        $say = 0;
        foreach($Curl as $curl){
            $content = curl_multi_getcontent($curl);
			$html[$say] = $content;
			$say++;
        }
        curl_multi_close($MultiCurlHandler);
		return $html;
	}
}
?>