<?php get_header(); ?>
<?php the_post(); ?>

<?php
global $post;
$attachments = get_children( array( 'post_parent' => $post->post_parent, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID' ) );

$isReklam = false;
$attachmentIDs = array();
foreach ( $attachments as $attachment ) {
	if(get_post_thumbnail_id($post->post_parent) != $attachment->ID) {
		$attachmentIDs[] = $attachment->ID;
	}
}
$totalAttachmentNumber = count( $attachmentIDs );
$currentAttachmentNumber = array_search($post->ID, $attachmentIDs) + 1;
$attachmentNumbers = explode(',', xoption('attachmentNumbers'));
if(in_array($currentAttachmentNumber, $attachmentNumbers)) $isReklam = true;

if ($currentAttachmentNumber == $totalAttachmentNumber) {
	$category = get_the_category($post->post_parent);
	$nextAttachmentURL = get_category_link($category[0]->term_id);
	$prevAttachmentURL = get_attachment_link($attachmentIDs[$totalAttachmentNumber - 2]);
} elseif($currentAttachmentNumber == 1) {
	$nextAttachmentURL = get_attachment_link($attachmentIDs[1]);
} else {
	$nextAttachmentURL = get_attachment_link($attachmentIDs[$currentAttachmentNumber]);
	$prevAttachmentURL = get_attachment_link($attachmentIDs[$currentAttachmentNumber - 2]);
}

if(wp_is_mobile()) {
	$buttonCount = 4;
} else {
	$buttonCount = 8;
	$attachmentHash = "#main";
}
?>

<div id="main" class="attachment">
	<div class="innerContainer">
		<div id="attachmentHead" class="safirBox">
			<div class="attachmentImage">
				<?php if ($isReklam): ?>
					<div class="ads inner" style="margin:15px 0;">
						<?php safirAd('attachmentAd'); ?>
						<p style="line-height: 30px"><a href="#" class="skipAd"><?php _e("REKLAMI GEÇ", "lara"); ?></a></p>
					</div>
				<?php endif; ?>

				<div id="galleryContent" <?php if($isReklam): echo 'style="display:none;"'; endif; ?>>
					<div id="image">
						<a href="<?php echo $nextAttachmentURL; ?><?php echo $attachmentHash ?>" title="<?php the_title(); ?>" rel="attachment" >
							<?php echo wp_get_attachment_image( $post->ID, 'full'); ?>
						</a>
					</div>
					<div id="gallery-nav" data-prev="<?php echo $prevAttachmentURL; ?>
						<?php echo $attachmentHash ?>" data-next="<?php echo $nextAttachmentURL; ?><?php echo $attachmentHash ?>">
						<?php
						if($totalAttachmentNumber<=$buttonCount) {
							$counter = 0;
							foreach ($attachmentIDs as $ID) : $counter++;
								?><a href="<?php echo get_attachment_link($ID);?><?php echo $attachmentHash ?>" class="<?php if($currentAttachmentNumber == $counter) echo 'active'?>"><?php echo $counter; ?></a><?php
							endforeach;
						} else {
							if($currentAttachmentNumber != 1) {
								?><a class="arrow first" href="<?php echo get_attachment_link($attachmentIDs[0]);?><?php echo $attachmentHash ?>"></a><a class="arrow left" style="font-size:8px;" href="<?php echo get_attachment_link($attachmentIDs[$currentAttachmentNumber-2]);?><?php echo $attachmentHash ?>"></a><?php
							}

							/*Middle*/
							if($totalAttachmentNumber == $buttonCount) {
								$galleryNumbers = range(1,$buttonCount);
							} else {
								if($currentAttachmentNumber<=($buttonCount/2)) {
									$galleryNumbers = range(1,$buttonCount);
								} elseif( ($totalAttachmentNumber - $currentAttachmentNumber) <= ($buttonCount/2-1)) {
									$galleryNumbers = range($totalAttachmentNumber - $buttonCount + 1, $totalAttachmentNumber);
								} else {
									$galleryNumbers = range($currentAttachmentNumber-$buttonCount/2+1, $currentAttachmentNumber+$buttonCount/2);
								}
							}
							foreach ($galleryNumbers as $galleryNumber) {
								?><a <?php if($currentAttachmentNumber == $galleryNumber) echo 'class="active"'; ?> href="<?php echo get_attachment_link($attachmentIDs[$galleryNumber-1]);?><?php echo $attachmentHash ?>"><?php echo $galleryNumber ?></a><?php
							}
							/*Middle*/

							if($currentAttachmentNumber != $totalAttachmentNumber) {
								?><a class="arrow right" style="font-size:8px;" href="<?php echo get_attachment_link($attachmentIDs[$currentAttachmentNumber]);?><?php echo $attachmentHash ?>"></a><a class="arrow last" href="<?php echo get_attachment_link($attachmentIDs[$totalAttachmentNumber-1]);?><?php echo $attachmentHash ?>"></a><?php
							}
						}
						?>
					</div>
					<?php if(!wp_is_mobile()) : ?>
						<div style="text-align:center;font-size:11px;margin-top:10px;color:#999">
							<?php _e("Bilgi: Klavye yön tuşlarını kullanarak galeri resimleri arasında geçiş yapabilirsiniz.", "lara"); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<div class="attachmentInfo">
				<div class="pageHeading">
					<h1 class="title"><?php the_title(); ?></h1>
					<?php if(xoption('breadcrumb')) : ?>
						<div id="breadcrumb">
							<?php sfrBreadcrumbs(); ?>
						</div>
					<?php endif; ?>
				</div>
				<?php if(xoption('showShareButtons')) : ?>
					<div class="share safirSocial" style="overflow:hidden;">
						<ul>
							<li class="facebook">
								<a rel="external" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" title="<?php _e("Konuyu Facebook'ta Paylaş", "lara"); ?>"></a>
							</li>
							<li class="twitter">
								<a rel="external" href="https://www.twitter.com/share?url=<?php the_permalink(); ?>&amp;text=<?php the_title();?>" title="<?php _e("Konuyu Twitter'da Paylaş", "lara"); ?>"></a>
							</li>
							<li class="whatsapp">
								<a rel="external" href="whatsapp://send?text=<?php the_title() ?> - <?php the_permalink() ?>" title="<?php _e("Konuyu Whatsapp'ta Paylaş", "lara"); ?>"></a>
							</li>
						</ul>
					</div>
				<?php endif; ?>
				<div class="reading nojust">
					<?php the_content();?>
				</div>
				<?php safirAd('galleryAd1', 'ads') ?>
			</div>
		</div>
	</div>
	<div class="innerContainer margintop">
		<div id="content">
			<?php
			// BENZER YAZILAR:
			if(xoption('relatedAttachmentCount') != 0) :

				$catIDs = "";
				foreach(get_the_category($post->post_parent) as $category) {
					if( $catIDs != "" ) { $catIDs .= ","; }
					$catIDs .= $category->cat_ID;
				}

				$query = new wp_query(array('cat'=>$catIDs, 'posts_per_page'=>xoption('relatedAttachmentCount'), 'orderby' => 'rand', 'post__not_in' => array($post->post_parent)));

				if($query->have_posts()) : ?>
					<div id="related">
						<div class="mainHeading stick">
							<div class="safiricon icon icon72"></div>
							<div class="title"><?php _e("DİĞER GALERİLER", "lara") ?></div>
						</div>
						<div class="safirBox" style="margin: 0">
							<div class="galleryWidget listing homeWidget" style="margin: 0">
								<div class="items">
									<?php
									$icon = "icon72";
									while ($query->have_posts()) : $query->the_post();
										include(TEMPLATEPATH . '/posts/post-gallery.php');
									endwhile;
									?>
								</div>
							</div>
						</div>
					</div>
					<?php
				endif;
			endif;
			wp_reset_postdata();
			?>
			<?php comments_template(); ?>
		<?php get_sidebar("photo"); ?>
<?php get_footer(); ?>
