<?php

// READING OPTINS
	if(get_option('posts_per_page') == 10) update_option('posts_per_page', 18);
	update_option("show_on_front", "posts");

// PAGES
	$pages = array(
		'authors'       => 'Tüm Yazarlar',
		'membership'	=> 'Üyelik',
		'horoscopes'	=> 'Burçlar',
		'icons'			=> 'Tema İkonları',
		);

	$createdPages = array();

	foreach ($pages as $key => $value) {
		if(get_page_by_title($value) == null) {
			$post_id = wp_insert_post(
				array(
					'post_title'    =>  $value,
					'post_status'   =>  'publish',
					'post_type'     =>  'page'
				)
			);
			update_post_meta($post_id, "_wp_page_template", "pages/page-" . $key . ".php");
			$createdPages[$key] = $post_id;
		}
	}

// PROFILE
	$pages = array(
		'posts'			=> 'İçerik Yönetimi',
		'posts-add'		=> 'İçerik Ekle',
		'posts-edit'	=> 'İçerik Düzenle',
		'profile'		=> 'Profil',
	);

	foreach ($pages as $key => $value) {
		if(get_page_by_title($value) == null) {
			$post_id = wp_insert_post(
				array(
					'post_title'    =>  $value,
					'post_status'   =>  'publish',
					'post_type'     =>  'page'
				)
			);
			update_post_meta($post_id, "_wp_page_template", "profile/page-" . $key . ".php");
			$createdPages[$key] = $post_id;
		}
	}

	setxoption('postsPage', $createdPages['posts']);
	setxoption('addPostsPage', $createdPages['posts-add']);
	setxoption('editPostsPage', $createdPages['posts-edit']);
	setxoption('profilePage', $createdPages['profile']);
	setxoption('membershipPage', $createdPages['membership']);


// MENUS
	$menuItems = wp_get_nav_menus();
	if(count($menuItems) == 0) {
		$menus = array(
			'topmenu'		=>	'Üst Menü',
			'mainmenu'		=>	'Ana Menü',
			'mobilemenu'	=>	'Mobil Menü',
			'footermenu1'	=>	'Footer Menü 1',
			'footermenu2'	=>	'Footer Menü 2'
		);
	}
	foreach ($menus as $menulocation => $menuname) {
		$menu_exists = wp_get_nav_menu_object( $menuname );
		if( !$menu_exists) {
			$menu_id = wp_create_nav_menu($menuname);
			if( !has_nav_menu( $menulocation ) ) {
				$locations = get_theme_mod('nav_menu_locations');
				$locations[$menulocation] = $menu_id;
				set_theme_mod( 'nav_menu_locations', $locations );
				wp_update_nav_menu_item($menu_id, 0, array(
					'menu-item-title' =>  'Menüye Eleman Ekleyiniz',
					'menu-item-url' => home_url('wp-admin/nav-menus.php?action=edit&menu=' . $menu_id),
					'menu-item-status' => 'publish')
				);
			}
		}
	}
