<?php if( is_array(xoption('meta')) ) : ?>
<div class="metaBox">
	<?php
	foreach(xoption('meta') as $meta) {
		switch ($meta) {
			case 'category':
			?>
				<div class="meta category"><div class="icon"></div><?php safirCategoryMeta(); ?></div>
			<?php
			break;
			case 'date':
			?>
				<div class="meta date"><div class="icon"></div><?php the_time('d.m.Y'); ?></div>
			<?php
			break;
			case 'hit':
			?>
				<div class="meta hit"><div class="icon"></div>
					<?php
					if(function_exists('the_views')) {
						$postHit = get_post_meta($post->ID, 'views', true);
					} else {
						$postHit = get_post_meta($post->ID, 'hit', true);
					}
					if ($postHit == NULL) { $postHit = 1; }
					echo number_format($postHit, 0, '', '.');
					?>
				</div>
			<?php
			break;
			case 'comment':
			?>
				<div class="meta comment">
					<div class="icon"></div>
					<a href="<?php the_permalink(); ?>#comments" rel="nofollow">
					<?php comments_number("0", "1", "%"); ?></a>
				</div>
			<?php
			break;
		}
	}
	?>
	<?php if(xoption('showShareButtons')) : ?>
		<div class="share safirSocial">
			<ul>
				<li class="facebook">
					<a rel="external" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" title="<?php _e("Konuyu Facebook'ta Paylaş", "lara"); ?>"></a>
				</li>
				<li class="twitter">
					<a rel="external" href="https://www.twitter.com/share?url=<?php the_permalink(); ?>&amp;text=<?php echo urlencode(get_the_title());?>" title="<?php _e("Konuyu Twitter'da Paylaş", "lara"); ?>"></a>
				</li>
				<li class="whatsapp">
					<a rel="external" href="whatsapp://send?text=<?php echo urlencode(get_the_title()) ?>-<?php the_permalink() ?>" data-action="share/whatsapp/share" title="<?php _e("Konuyu Whatsapp'ta Paylaş", "lara"); ?>"></a>
				</li>
			</ul>
		</div>
	<?php endif; ?>
</div>
<?php endif; ?>
