<?php
global $widgetPlace;
global $activeMenu;
$widgetPlace = "sidebar";

$current_user = wp_get_current_user();
$authorID = $current_user->ID;
$authorName = get_the_author_meta( 'first_name', $authorID ) . ' ' . get_the_author_meta( 'last_name', $authorID );
if($authorName == " ") {
	$authorName = get_the_author_meta( 'display_name', $authorID );
}
$authorMail = get_the_author_meta( 'user_email', $authorID );
$authorLogin = get_the_author_meta( 'user_login', $authorID );
$authorSite = get_the_author_meta( 'user_url', $authorID );

global $wpdb;
$image = safir_get_author_image($authorID);
?>

<aside class="profile">
<div class="safirBox">
	<div class="thumb avatar">
		<div class="image">
			<a href="<?php echo get_permalink(xoption('profilePage')) ?>"><img src="<?php echo $image; ?>" width="150" height="150" /></a>
		</div>
		<div class="name"><?php echo $authorName; ?></div>
	</div>

	<div class="userMenu">
		<ul>
			<li>
				<a href="<?php echo get_permalink(xoption('profilePage')) ?>">
					<div class="icon profile"><span></span></div>
					<div class="title"><?php _e("Profilimi Düzenle", "lara"); ?></div>
				</a>
			</li>
			<li>
				<?php if(xoption('postsPage') != "-1") : ?>
				<a href="<?php echo get_permalink(xoption('postsPage')) ?>">
					<div class="icon posts"><span></span></div>
					<div class="title"><?php _e("İçerik Yönetimi", "lara"); ?></div>
				</a>
				<?php endif; ?>
			</li>
			<li>
				<?php if(xoption('addPostsPage') != "-1") : ?>
				<a href="<?php echo get_permalink(xoption('addPostsPage')) ?>">
					<div class="icon add"><span></span></div>
					<div class="title"><?php _e("İçerik Ekle", "lara"); ?></div>
				</a>
				<?php endif; ?>
			</li>
			<li>
				<a href="<?php echo get_author_posts_url($authorID) ?>">
					<div class="icon user"><span></span></div>
					<div class="title"><?php _e("Yazar Sayfam", "lara"); ?></div>
				</a>
			</li>
			<li>
				<a class="logout" href="<?php echo wp_logout_url(get_bloginfo('url')) ?>">
					<div class="icon logout"><span></span></div>
					<div class="title"><?php _e("Güvenli Çıkış Yap", "lara"); ?></div>
				</a>
			</li>
		</ul>
	</div>
</div>
</aside>
