<?php
/*
	Template Name: İçerik Yönetimi
*/
?>
<?php
if(!is_user_logged_in()) { wp_redirect(get_page_link(xoption("membershipPage"))); die(); }
?>

<?php get_header() ?>
<div id="profile" class="safirBox posts">

	<div class="pageHeading">
		<h1 class="title"><?php the_title() ?></h1>
		<?php if(xoption('addNewsPage') != "-1") : ?>
			<div class="profileButtons">
				<a class="add" href="<?php echo get_permalink(xoption('addPostsPage')) ?>"><?php _e("Yeni Yazı Ekle", "lara") ?>
				</a>
			</div>
		<?php endif; ?>
	</div>

	<?php
	$current_user = wp_get_current_user();
	$authorID = $current_user->ID;
	?>

	<div class="sfrManagePosts">
		<div class="table">
			<?php
			if(isset($_GET['sayfa'])) {
				$activePage = $_GET['sayfa'];
			} else {
				$activePage = 1;
			}
			$postsPerPage = 10;

			$authorQuery = new WP_Query(array(
				'paged' 			=> $activePage,
				'posts_per_page'	=> $postsPerPage,
				'author'			=> $authorID,
				'post_status'		=> array('publish','draft','pending','future'),
				));
			if($authorQuery->have_posts()) :
				while ($authorQuery->have_posts()) : $authorQuery->the_post();
					?>
					<div class="postContainer">
						<div class="thumb td">
							<div class="safirthumb">
								<a href="<?php the_permalink(); ?>">
									<?php safirthumb(); ?>
								</a>
							</div>
						</div>

						<div class="title td">
							<a rel="external" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</div>

						<div class="category td"><?php the_category('<br/>'); ?></div>

						<div class="date td"><?php the_time('d.m.Y'); ?></div>

						<?php if(xoption('profileEditPosts')) : ?>
							<div class="button td">
								<div class="poststatus">
									<?php
									$poststatus = get_post_status();
									switch ($poststatus) {
									 	case 'publish':
									 		?><a class="safirButton edit" href="<?php echo get_page_link(xoption('editPostsPage')) ?>?post=<?php echo get_the_ID() ?>"><?php _e("Düzenle", "lara") ?></a><?php
									 		break;

									 	case 'draft':
									 		echo '<span class="' . $poststatus . '">' . __("Taslak", "lara") . '</span>';
									 		break;

									 	case 'future':
									 		echo '<span class="' . $poststatus . '">' . __("Zamanlandı", "lara") . '</span>';
									 		break;

									 	case 'pending':
									 		echo '<span class="' . $poststatus . '">' . __("Onay Bekliyor", "lara") . '</span>';
									 		break;

									 	default:
									 		echo '<span>' . $poststatus . '</span>';
									 		break;
									 }
									?>
								</div>
							</div>
						<?php else : ?>
							<div class="poststatus td">
								<?php
								$poststatus = get_post_status();
								switch ($poststatus) {
								 	case 'publish':
								 		echo '<span class="' . $poststatus . '">' . __("Yayınlandı", "lara") . '</span>';
								 		break;

								 	case 'draft':
								 		echo '<span class="' . $poststatus . '">' . __("Taslak", "lara") . '</span>';
								 		break;

								 	case 'future':
								 		echo '<span class="' . $poststatus . '">' . __("Zamanlandı", "lara") . '</span>';
								 		break;

								 	case 'pending':
								 		echo '<span class="' . $poststatus . '">' . __("Onay Bekliyor", "lara") . '</span>';
								 		break;

								 	default:
								 		echo '<span>' . $poststatus . '</span>';
								 		break;
								 }
								?>
							</div>
						<?php endif; ?>
					</div>
					<?php
				endwhile;
			else :
				echo('<p class="status warning" style="margin:20px">' . __("İçerik bulunamadı", "lara") . '.</p>');
			endif;
			wp_reset_postdata();
			?>
		</div>
	</div>
	<div class="navi" style="margin-top:20px">
	<?php
		$totalItems = $authorQuery->found_posts;
		echo safirPaginationString($page = $activePage, $totalItems, $limit = $postsPerPage, $adjacents = 2, $targetpage = get_permalink(xoption('postsPage')), $pagestring = "?sayfa=")
	?>
	</div>
</div>

</div><!--content-->

<?php
global $activeMenu;
$activeMenu = 'posts';
include( TEMPLATEPATH . '/profile/aside.php');
?>

</div>
<!--main-->

<?php get_footer(); ?>
