<?php
/*
	Template Name: Profil
*/
?>
<?php
if(!is_user_logged_in()) { wp_redirect(get_page_link(xoption("membershipPage"))); die(); }

$current_user = wp_get_current_user();
$authorID = $current_user->ID;
$result = array();
if($authorID == SAFIR_DEMO_USERID) {
	$result = array('class'=>'status warning', 'message'=> __("Demo kullanıcısı düzenleme yapamaz.", "lara") );
} else {
	if(isset($_POST['task']) && $_POST['task'] == 'editprofile' ) {
		$result = array();
		$name = sanitize_text_field($_POST['firstname']);
		$surname = sanitize_text_field($_POST['surname']);
		$mail = sanitize_text_field($_POST['mail']);
		$password1 = sanitize_text_field($_POST['password1']);
		$password2 = sanitize_text_field($_POST['password2']);
		$content = $_POST['sfr_newscontent'];

		if(!filter_var($mail, FILTER_VALIDATE_EMAIL)) {
			$result = array('class'=>'status warning', 'message'=>__('Mail adresinizi geçersiz girdiniz.', 'lara'));
		} else {

			$userArray = array(
				'ID' => $authorID,
				'first_name' => $name,
				'last_name' => $surname,
				'user_email' => $mail,
				'description' => $content,
			);
			$doUpdate = false;

			if($password1) {
				if($password1 != $password2) {
					$result = array('class'=>'status warning', 'message'=>__('Girdiğiniz şifreler uyuşmuyor', 'lara'));
				} else {
					$userArray['user_pass'] = $password1;
					$doUpdate = true;
				}
			} else {
				$doUpdate = true;
			}

			if($doUpdate) {
				$attachmentIDs = array();
				$uploadCounter = 0;
				foreach( $_FILES as $file ) {
					if( is_array( $file ) && $file['name'] ) {
						$uploadCounter++;
						$allowed =  array('gif','png','jpg','jpeg');
						$filename = $file['name'];
						$filesize = $file['size'];
						$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
						if( $file['error'] == 0 && in_array(strtolower($ext), $allowed) && $filesize < SAFIR_MAX_UPLOAD_SIZE ) {
							$attachmentIDs[] = safir_upload_user_file( $file );
						}
					}
				}
				if(count($attachmentIDs) == $uploadCounter) {
					$doUpdate = true;
				} else {
					$doUpdate = false;
					$result = array('class'=>'status warning', 'message'=>__('Profil resmi yüklenemedi. Lütfen dosya uzantısına ve boyutun en fazla 2 MB olmasına dikkat ediniz.', 'lara'));
					foreach ($attachmentIDs as $attachmentID) {
						wp_delete_attachment($attachmentID, true);
					}
				}
			}

			if($doUpdate) {
				$user_id = wp_update_user( $userArray );
				if( is_wp_error($user_id) ) {
					$result = array('class'=>'status warning', 'message'=>$user_id->get_error_message());
				} else {
					if(count($attachmentIDs)>0) : update_user_meta( $authorID, 'safirAvatar',  wp_get_attachment_url($attachmentIDs[0]) ); endif;
					$result = array('class'=>'status success', 'message'=>__('Profil bilgileriniz başarılı bir şekilde değiştirildi.','lara'));
				}
			}
		}

	}
}
?>

<?php get_header() ?>
<div class="safirBox">
<div class="pageHeading">
<h1 class="title"><?php the_title() ?></h1>
</div>

<div id="profile" class="editprofile">
	<?php
		$authorID = $current_user->ID;
		if(isset($_POST['task']) && $_POST['task'] == 'editprofile' ) {
			$authorName = sanitize_text_field($_POST['firstname']);
			$authorSurname = sanitize_text_field($_POST['surname']);
			$authorMail = sanitize_text_field($_POST['mail']);
			$content = ($_POST['sfr_newscontent']);
		} else {
			$authorName = get_the_author_meta( 'first_name', $authorID );
			$authorSurname = get_the_author_meta( 'last_name', $authorID );
			$authorMail = get_the_author_meta( 'user_email', $authorID );
			$content = get_the_author_meta( 'user_description', $authorID );
		}
	?>

	<div class="sfrIconForm">
		<form class="editprofile" method="post" enctype="multipart/form-data">
			<?php
			if(!$result) {
				$result = array('class' => 'status info', 'message' => __('Profil bilgilerinizi aşağıdaki form aracılığıyla değiştirebilirsiniz.','lara'));
			}
			?>
			<p class="<?php echo $result['class'] ?>" data-loading="<?php _e("Lütfen bekleyiniz", "lara") ?>..."><?php echo $result['message'] ?></p>
			<div class="container half">
				<div class="itemContainer">
					<div class="item identity">
						<div class="icon"><span></span></div>
						<input name="firstname" type="text" placeholder="<?php _e("Adınız", "lara") ?>" value="<?php echo $authorName ?>" />
					</div>
				</div>
				<div class="itemContainer">
					<div class="item identity">
						<div class="icon"><span></span></div>
						<input name="surname" type="text" placeholder="<?php _e("Soyadınız", "lara") ?>" value="<?php echo $authorSurname ?>" />
					</div>
				</div>
				<div class="itemContainer">
					<div class="item password">
						<div class="icon"><span></span></div>
						<input name="password1" type="password" placeholder="<?php _e("Yeni şifreniz (Değiştirmek istiyorsanız)", "lara") ?>" />
					</div>
				</div>
				<div class="itemContainer">
					<div class="item password">
						<div class="icon"><span></span></div>
						<input name="password2" type="password" placeholder="<?php _e("Yeni şifreniz (tekrar)", "lara") ?>" />
					</div>
				</div>
				<div class="itemContainer">
					<div class="item mail">
						<div class="icon"><span></span></div>
						<input name="mail" type="text" placeholder="<?php _e("E-posta adresiniz", "lara") ?> *" value="<?php echo $authorMail ?>" />
					</div>
				</div>
				<div class="itemContainer">
					<div class="item image">
						<div class="icon"><span></span></div>
						<label class="fileLabel" for="file.profileImage"><span class="text"><?php _e("Profil Resminiz", "lara") ?></span><span class="button"><?php _e("Resim Seç", "lara") ?></span></label><input id="file.profileImage" name="image" type="file" accept="image/*" />
					</div>
				</div>
			</div>
			<p><?php _e("Hakkınızda kısa bir bilgiyi aşağıya girebilirsiniz. Bu metin yazar profil sayfanızda görünecektir", "lara") ?>.</p>
			<div class="container">
				<div class="itemContainer">
					<div class="item">
						<?php wp_editor(stripslashes($content), 'sfr_newscontent', array(
							'editor_height' => 220,
							'media_buttons'	=> false,
							'quicktags'		=> false,
							'tinymce' 		=> array('toolbar1'=> 'bold italic underline link unlink forecolorc', 'toolbar2'=>''),
						)); ?>
					</div>
				</div>
			</div>
			<input type="hidden" name="task" value="editprofile">
			<button class="check submit"><?php _e("Değişiklikleri Kaydet", "lara"); ?></button>
		</form>
	</div>
</div>

</div>

</div><!--content-->

<?php
global $activeMenu;
$activeMenu = 'profile';
include( TEMPLATEPATH . '/profile/aside.php');
?>

</div>
<!--main-->

<?php get_footer(); ?>
