jQuery(document).ready(function($){
	// Instantiates the variable that holds the media library frame.
	var meta_image_frame;
	var input;
	// Runs when the image button is clicked.
	$('.mediaButton').live("click", function(e) {
		input = $(this).prev();
		var image = $(this).next();
		var hiddenwidth = $(this).closest('.safirpanelItem').next();
		var hiddenheight = hiddenwidth.next();

		// Prevents the default action from occuring.
		e.preventDefault();

		// If the frame already exists, re-open it.
		if ( meta_image_frame ) {
			meta_image_frame.open();
			return;
		}

		// Sets up the media library frame
		meta_image_frame = wp.media.frames.meta_image_frame = wp.media({
			title: meta_image.title,
			button: { text:  meta_image.button },
			library: { type: 'image' }
		});

		// Runs when an image is selected.
		meta_image_frame.on('select', function(){

			// Grabs the attachment selection and creates a JSON representation of the model.
			var media_attachment = meta_image_frame.state().get('selection').first().toJSON();

			// Sends the attachment URL to our custom image input field.
			input.trigger('change').val(media_attachment.url);
			image.attr('src', media_attachment.url);
			hiddenwidth.val(media_attachment.width);
			hiddenheight.val(media_attachment.height);
		});

		// Opens the media library frame.
		meta_image_frame.open();
	});
});
