<?php

// SESSION

	function safir_start_session(){
	    if(!session_id()) session_start();
	}

	add_action('init', 'safir_start_session');

// LANGUAGE

	load_theme_textdomain( 'lara', get_template_directory() . '/languages' );

// CONSTANTS

	define('SAFIR_THEME_SLUG', 'lara');
	define('SAFIR_MAX_UPLOAD_SIZE', 2*1024*1024);
	define('SAFIR_DEMO_USERID', 999);
	define('SAFIR_CACHE_ENABLED', TRUE);
	define('SAFIR_CACHE_TIME', DAY_IN_SECONDS);
	define('SAFIR_MENU_CACHE_TIME', DAY_IN_SECONDS);
	define('SAFIR_WIDGET_CACHE_TIME', DAY_IN_SECONDS);
	define('SAFIR_EXTERNAL_CACHE_TIME', HOUR_IN_SECONDS);

// ICONS

	include("lib/safirtema/icons.php");

// MENUS

	add_action('init', 'register_my_menus');
	function register_my_menus() {
		register_nav_menus(array('topmenu'=>'Üst Menü'));
		register_nav_menus(array('mainmenu'=>'Ana Menü'));
		register_nav_menus(array('mobilemenu'=>'Mobil Menü'));
		register_nav_menus(array('footermenu1'=>'Footer Menü 1'));
		register_nav_menus(array('footermenu2'=>'Footer Menü 2'));
	}

	function safir_nav_menu($theme_location) {
		$menu = get_transient('nav-' . $theme_location);
		if( $menu === false ) {
			$menu = wp_nav_menu( array(
				'theme_location'	=> $theme_location,
				'container'			=> 'ul',
				'fallback_cb'		=> false,
				'walker'			=> new sfrIconMenuWalker(),
				'echo'				=> 0,
			) );
			if(SAFIR_CACHE_ENABLED) safir_set_transient( 'nav-' . $theme_location, $menu, SAFIR_MENU_CACHE_TIME );
		}
		echo $menu;
	}

	add_action( 'wp_update_nav_menu', 'safir_delete_cache_menu' );
	add_action( 'update_option_permalink_structure', 'safir_delete_cache' );


	// Walkers

		class sfrIconMenuWalker extends Walker_Nav_Menu {
			function start_el(&$output, $item, $depth = 0, $args = Array(), $id = 0) {
				global $wp_query;
				$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
				$class_names = $value = '';
				$classes = empty( $item->classes ) ? array() : (array) $item->classes;
				$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
				$class_names = ' class="' . esc_attr( $class_names ) . '"';
				$output .= $indent . '<li ' . $value . $class_names .'>';
				$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
				$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
				$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
				$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

				$sfr_menu_icon = "";
				$sfr_menu_icon = get_post_meta( $item->ID, '_menu_item_sfr_menu_icon', true );
				if($sfr_menu_icon) {
					$sfr_menu_icon = '<div class="safiricon icon '.$sfr_menu_icon.'"></div>';
				}
				$item_output = $args->before;
				$item_output .= '<a'. $attributes .'>'.$sfr_menu_icon.'<div class="text">';
				$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
				$item_output .= '</div></a>';
				$item_output .= $args->after;

				$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
			}
		}



function safirAd($ads, $class = '') {
	if(wp_is_mobile()) {
		if($x = xoption($ads . 'Mobile')) { ?>
			<div class="<?php echo $class ?>"><?php echo $x ?></div>
			<?php
		}
	} else {
		if($x = xoption($ads . 'Desktop')) { ?>
			<div class="<?php echo $class ?>"><?php echo $x ?></div>
			<?php
		}
	}
}

function getSafirAd($ads, $class = '') {
	if(wp_is_mobile()) {
		if($x = xoption($ads . 'Mobile')) {
			return '<div class="' . $class . '">'.  $x . '</div>';
		}
	} else {
		if($x = xoption($ads . 'Desktop')) {
			return '<div class="' . $class . '">'.  $x . '</div>';
		}
	}
}

function safirCategoryMeta() {
	?>
	<div class="safirCategoryMeta">
		<?php
		$categories = get_the_category();
		$excludes = xoption("metaExcludeCategory");
		foreach ($categories as $category) {
			if(is_array($excludes)) {
				if(!in_array($category->term_id, $excludes)) {
					?>
					<a href="<?php echo get_category_link($category->term_id) ?>"><?php echo $category->name; ?></a>
					<?php
				}
			} else {
				?>
				<a href="<?php echo get_category_link($category->term_id) ?>"><?php echo $category->name; ?></a>
				<?php
			}
		}
		?>
	</div>
	<?php
}

function safirMetas($metas) {
	if(is_array($metas)) :
		?>
		<div class="safirMetas">
		<?php
		foreach ($metas as $meta) {
			switch ($meta) {
				case 'category':
					?>
					<div class="meta category"><?php the_category(", "); ?></div>
					<?php
				break;
				case 'date':
					?>
					<div class="meta date"><?php the_time('d.m.Y'); ?></div>
					<?php
				break;
				case 'hit':
					?>
					<div class="meta hit">
						<?php
						if(function_exists('the_views')) {
							$postHit = get_post_meta(get_the_ID(), 'views', true);
						} else {
							$postHit = get_post_meta(get_the_ID(), 'hit', true);
						}
						if ($postHit == NULL) { $postHit = 1; }
						echo number_format($postHit, 0, '', '.'); ?>
					</div>
					<?php
				break;
				case 'comment':
					?>
					<div class="meta comment"><?php comments_popup_link('0','1','%'); ?></div>
					<?php
				break;
				case 'author':
					?>
					<div class="meta author"><?php the_author_posts_link(); ?></div>
					<?php
				break;
			}
		}
		?>
		</div>
		<?php
	endif;
}



add_filter( 'the_content', 'safir_insert_post_ads');
function safir_insert_post_ads( $content ) {
	if ( !is_attachment() && is_single() && ! is_admin() ) {
		return safir_insert_after_paragraph($content );
	}
	return $content;
}

function safir_insert_after_paragraph( $content ) {
	$closing_p = '</p>';
	$paragraphs = explode( $closing_p, $content );
	foreach ($paragraphs as $index => $paragraph) {

		if ( trim( $paragraph ) ) {
			//$paragraphs[$index] .= $closing_p;
		}

		if ( xoption("singleAdAra1Pos") == $index) {
			$paragraphs[$index] .= "<div class=ads>" . getSafirAd("singleAdAra1") . "</div>";
		}

		if ( xoption("singleAdAra2Pos") == $index ) {
			$paragraphs[$index] .= "<div class=ads>" . getSafirAd("singleAdAra2") . "</div>";
		}
	}

	return implode( '', $paragraphs );
}






include('lib/safirtema/breadcrumbs.php');
include('lib/aq_resizer.php');

// safirthumb()
	function safirthumb() {
		?>
		<div class="thumbnail">
			<div class="center">
				<?php
				// Custom Field
				if($x = xoption("thumbCustomField")) {
					$image = get_post_meta(get_the_ID(), $x, true);
				}

				if(isset($image)) {
					?><img src="<?php safirLazyThumb($image) ?>" alt="<?php the_title() ?>" width="160" height="90" /><?php
				} else {
					if(has_post_thumbnail()) {
						$image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full');
						?><img <?php safirLazyThumb($image[0]) ?> alt="<?php the_title() ?>" width="<?php echo $image[1]?>" height="<?php echo $image[2] ?>" /><?php
					} else {
						?><img <?php safirLazyThumb(xoption("noimageforpost")) ?> alt="<?php the_title() ?>" width="160" height="90" /><?php
					}
				}
				?>
			</div>
		</div>
		<?php
	}

	function safirLazyThumb($image) {
		if(xoption("lazyload")) {
			echo 'src="' . xoption("noimageforpost") . '" data-src="' . $image . '" class="lazy"';
		} else {
			echo 'src="' . $image . '"';
		}
	}


// Author Page Post Count
	add_action( 'pre_get_posts', 'safir_author_category_post_count' );
	function safir_author_category_post_count( $query ) {

		if( $query->is_main_query() && !is_admin() && ( is_category(xoption('articleCategory')) || ( is_author() ) ) )  {
			$query->set( 'posts_per_page', xoption('authorPostCount') );
		}
	}


// Get Author Image
	function safir_get_author_image($authorID) {
		$image = get_user_meta($authorID, 'safirAvatar', true);
		if($image) {
			$aqData = aq_resize($image, 300, 300, true, false, true);
			if($aqData) {
				$image = $aqData[0];
			} else {
				$image = get_bloginfo("template_url") . "/images/noauthor.png";
			}
		} else {
			$image = get_bloginfo("template_url") . "/images/noauthor.png";
		}
		return $image;
	}


// Styles

function sfr_scripts() {
	wp_enqueue_style('safirstyle', get_template_directory_uri() . '/style.css');
	wp_deregister_script( 'jquery' );
	wp_register_script( 'jquery', 'https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js', array(), null, true );
	wp_enqueue_script( 'jquery' );

	if(is_single() || is_page()) :
		wp_enqueue_script( 'colorbox', get_template_directory_uri() . '/lib/colorbox/jquery.colorbox-min.js', 'jquery', NULL, true );
	endif;

	wp_enqueue_script( 'sfrowl', get_template_directory_uri() . '/lib/owl-carousel/owl.carousel.min.js', array('jquery'), NULL, true );
	if(xoption('userColor') && !wp_is_mobile()) :
		wp_enqueue_script( 'minicolors', get_template_directory_uri() . '/lib/colorpicker/jquery.minicolors.min.js', array('jquery'), NULL, true );
		wp_enqueue_style('minicolors', get_template_directory_uri() . '/lib/colorpicker/jquery.minicolors.css');
	endif;
	wp_register_script("sfrscripts", get_template_directory_uri() . '/scripts/scripts.js', array('jquery'), NULL, true);
	wp_localize_script('sfrscripts', 'safirAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php')));
	wp_enqueue_script('sfrscripts');
}

add_action( 'wp_enqueue_scripts', 'sfr_scripts' );

// Remove generator meta tag

	remove_action('wp_head', 'wp_generator');

// Theme Support

	add_action( 'after_setup_theme', 'safir_theme_functions' );
	function safir_theme_functions() {
	    add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
	}

// Sidebar Widgets
	if (function_exists('register_sidebar')) {
		register_sidebar(array(
			'name'=>'Sidebar - Genel',
			'id'=>'sidebar-general',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Genel Sidebar'
		));
		register_sidebar(array(
			'name'=>'Mobil Anasayfa',
			'id'=>'sidebar-mobile',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Mobil cihazlarda görünecek anasayfa sidebarı (Eğer bu alanı boş bırakırsanız masaüstü anasayfası gösterilecektir.)'
		));
		register_sidebar(array(
			'name'=>'Anasayfa Üst Geniş Blok',
			'id'=>'sidebar-anabolum-ust',
			'before_widget'=>'<div class="wideWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Anasayfa üst geniş blok bileşenlerini buraya ekleyiniz.'
		));
		register_sidebar(array(
			'name'=>'Anasayfa Orta Sol Blok 1',
			'id'=>'sidebar-anabolum-sol-1',
			'before_widget'=>'<div class="homeWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Anasayfa orta sol bölüm bileşenlerini buraya ekleyiniz.'
		));
		register_sidebar(array(
			'name'=>'Anasayfa Orta Sağ Blok 1',
			'id'=>'sidebar-anabolum-sag-1',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Anasayfa orta sağ bölüm bileşenlerini buraya ekleyiniz.'
		));
		register_sidebar(array(
			'name'=>'Anasayfa Orta Geniş Blok',
			'id'=>'sidebar-anabolum-orta',
			'before_widget'=>'<div class="wideWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Anasayfa alt geniş blok bileşenlerini buraya ekleyiniz.'
		));
		register_sidebar(array(
			'name'=>'Anasayfa Orta Sol Blok 2',
			'id'=>'sidebar-anabolum-sol-2',
			'before_widget'=>'<div class="homeWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Anasayfa orta sol bölüm bileşenlerini buraya ekleyiniz.'
		));
		register_sidebar(array(
			'name'=>'Anasayfa Orta Sağ Blok 2',
			'id'=>'sidebar-anabolum-sag-2',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Anasayfa orta sağ bölüm bileşenlerini buraya ekleyiniz.'
		));
		register_sidebar(array(
			'name'=>'Anasayfa Alt Geniş Blok',
			'id'=>'sidebar-anabolum-alt',
			'before_widget'=>'<div class="wideWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Anasayfa alt geniş blok bileşenlerini buraya ekleyiniz.'
		));
		register_sidebar(array(
			'name'=>'Anasayfa Dışındaki Üst Geniş Blok',
			'id'=>'sidebar-archive-ust',
			'before_widget'=>'<div class="wideWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Anasayfa dışındaki sayfalarda görünecek olan üst geniş blok bileşenlerini buraya ekleyiniz.'
		));
		register_sidebar(array(
			'name'=>'Sidebar - Tekil Sayfa',
			'id'=>'sidebar-single',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Ürün Konuları dışındaki tekil sayfalarda görünecek olan sidebar'
		));
		register_sidebar(array(
			'name'=>'Sidebar - Kategori',
			'id'=>'sidebar-category',
			'before_widget'=>'<div class="sidebarWidget nativeWidget safirBox">',
			'after_widget'=>'</div>',
			'before_title'=>'<div class="mainHeading"><div class="title">',
			'after_title'=>'</div></div>',
			'description'=>'Ürün kategorileri dışındaki kategorilerde görünecek olan sidebar'
		));
		register_sidebar(array(
			'name'=>'Sidebar - Video Galeri',
			'id'=>'sidebar-video',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Video galeri kategorileri ve konularında görünecek olan sidebar'
		));
		register_sidebar(array(
			'name'=>'Sidebar - Foto Galeri',
			'id'=>'sidebar-photo',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Foto galeri kategorileri ve konularında görünecek olan sidebar'
		));
		register_sidebar(array(
			'name'=>'Sidebar - Köşe Yazıları',
			'id'=>'sidebar-article',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Köşe yazıları kategorileri ve konularında görünecek olan sidebar'
		));
		register_sidebar(array(
			'name'=>'Sidebar - Sayfa',
			'id'=>'sidebar-page',
			'before_widget'=>'<div class="sidebarWidget nativeWidget"><div class="safirBox">',
			'after_widget'=>'</div></div>',
			'before_title'=>'<div class="mainHeading">',
			'after_title'=>'</div>',
			'description'=>'Sayfalarda görünecek olan sidebar'
		));
	}


// Get Author Image
function author($authorID, $size=100) {
	$image = get_avatar($authorID, $size);
	$image = explode('src="', $image);
	$image = explode('"', $image[1]);
	$image = $image[0];
	if(!$image) $image = get_user_meta($authorID, 'avatar', true);
	return $image;
}


function safirText($wordsCount, $echo = true, $excerpt = true) {
	global $post;
	if($excerpt && $x = get_the_excerpt()) :
		$string = safirBracket(strip_tags($x));
	else :
		$string = safirBracket(strip_tags(get_the_content()));
	endif;
	$array = explode(" ", $string);
	if (count($array)>$wordsCount) :
		array_splice($array, $wordsCount);
		$string = implode(" ", $array)."...";
	endif;
	if($echo) :
		echo $string;
	else :
		return $string;
	endif;
}

function safirText2($content, $wordsCount) {
	$string = safirBracket(strip_tags($content));
	$array = explode(" ", $string);
	if (count($array)>$wordsCount) :
		array_splice($array, $wordsCount);
		$string = implode(" ", $array)."...";
	endif;
	echo $string;
}

// Bracket Remover
function safirBracket($x) {
	$active = false;
	$result = "";
	$len = strlen($x);
	if($len>1) {
		for ($i=0; $i<=$len-1; $i++) {
			if(substr($x, $i, 1) == '[') {
				$active = true;
			}
			elseif (substr($x, $i, 1) == "]") {
				$active = false;
			}
			if($active == false && substr($x, $i, 1) != "]") {
				$result .= substr($x, $i, 1);
			}
		}
		return $result;
	}
}

// Safir Top Category
function safir_top_category($catID) {
	$curr_cat = get_category_parents($catID, false, '/' ,true);
	$curr_cat = explode('/',$curr_cat);
	$idObj = get_category_by_slug($curr_cat[0]);
	return $idObj->term_id;
}


// Author images

if( current_user_can('administrator')) :
	add_action( 'show_user_profile', 'sfr_show_extra_profile_fields' );
	add_action( 'edit_user_profile', 'sfr_show_extra_profile_fields' );
endif;

function sfr_show_extra_profile_fields( $user ) { ?>
	<h3>Kullanıcı Bilgileri</h3>
	<table class="form-table">
		<tr>
			<th><label for="safirAvatar">Yazar Resim Adresi</label></th>
			<td>
				<input type="text" name="safirAvatar" id="safirAvatar" value="<?php echo esc_attr( get_the_author_meta( 'safirAvatar', $user->ID ) ); ?>" class="regular-text" />
				<button type="button" class="button mediaButton">Resim Seç</button>
			</td>
		</tr>
		<tr>
			<th><label for="avatar">Yazar Facebook Adresi</label></th>
			<td>
				<input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'facebook', $user->ID ) ); ?>" class="regular-text" />
			</td>
		</tr>
		<tr>
			<th><label for="avatar">Yazar Twitter Adresi</label></th>
			<td>
				<input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'twitter', $user->ID ) ); ?>" class="regular-text" />
			</td>
		</tr>
		<tr>
			<th><label for="avatar">Yazar Instagram Adresi</label></th>
			<td>
				<input type="text" name="instagram" id="instagram" value="<?php echo esc_attr( get_the_author_meta( 'instagram', $user->ID ) ); ?>" class="regular-text" />
			</td>
		</tr>
		<tr>
			<th><label for="avatar">Yazar Linkedin Adresi</label></th>
			<td>
				<input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'linkedin', $user->ID ) ); ?>" class="regular-text" />
			</td>
		</tr>
	</table>
<?php }

add_action( 'personal_options_update', 'sfr_save_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'sfr_save_extra_profile_fields' );

function sfr_save_extra_profile_fields( $user_id ) {
	if ( !current_user_can( 'edit_user', $user_id ) )
		return false;
	update_user_meta( $user_id, 'safirAvatar', $_POST['safirAvatar'] );
	update_user_meta( $user_id, 'facebook', $_POST['facebook'] );
	update_user_meta( $user_id, 'twitter', $_POST['twitter'] );
	update_user_meta( $user_id, 'instagram', $_POST['instagram'] );
	update_user_meta( $user_id, 'linkedin', $_POST['linkedin'] );
}


// Cache Ayarları
if(SAFIR_CACHE_ENABLED) {
	add_action('save_post','safir_delete_cache');
	add_action('deleted_post', 'safir_delete_cache');
	add_action('wp_update_nav_menu', 'safir_delete_cache');
}

function safir_delete_cache_menu() {
	delete_transient('nav-topmenu');
	delete_transient('nav-mainmenu');
	delete_transient('nav-mobilemenu');
	delete_transient('nav-footermenu1');
	delete_transient('nav-footermenu2');
}

function safir_delete_cache() {
	safir_delete_cache_menu();
	session_unset();
	global $wpdb;
	$wpdb->query("DELETE FROM $wpdb->options WHERE option_name LIKE '_transient_sfr%' OR option_name LIKE '_transient_timeout_sfr%'");
}


// Image Script
	function sfr_image_enqueue() {
		if( is_admin() ) {
			wp_enqueue_media();

			wp_register_script( 'safiradmin', get_bloginfo('template_url') . '/safirpanel/scripts/safiradmin.js', array( 'jquery' ) );
			wp_register_script( 'meta-box-image', get_bloginfo('template_url') . '/safirpanel/scripts/image.js', array( 'jquery' ) );
			wp_localize_script( 'meta-box-image', 'meta_image',
				array(
					'title' => 'Bir Resim Seçin veya Bilgisayarınızdan Yükleyin',
					'button' => 'Bu Resmi Kullan',
				)
			);
			wp_enqueue_script( 'meta-box-image' );
			wp_enqueue_script( 'safiradmin' );
		}
	}
	add_action( 'admin_enqueue_scripts', 'sfr_image_enqueue' );


	function safir_admin_styles() {
		global $file_dir;
		wp_enqueue_style("safiradmin", $file_dir . "/safirpanel/css/admin.css", false, "0.1", "all");
	}

	add_action('admin_print_styles', 'safir_admin_styles');




function upload_user_file( $file = array() ) {

	require_once( ABSPATH . 'wp-admin/includes/admin.php' );

	  $file_return = wp_handle_upload( $file, array('test_form' => false ) );

	  if( isset( $file_return['error'] ) || isset( $file_return['upload_error_handler'] ) ) {
		  return false;
	  } else {

		  $filename = $file_return['file'];

		  $attachment = array(
			  'post_mime_type' => $file_return['type'],
			  'post_title' => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),
			  'post_content' => '',
			  'post_status' => 'inherit',
			  'guid' => $file_return['url']
		  );

		  $attachment_id = wp_insert_attachment( $attachment, $file_return['url'] );

		  require_once(ABSPATH . 'wp-admin/includes/image.php');
		  $attachment_data = wp_generate_attachment_metadata( $attachment_id, $filename );
		  wp_update_attachment_metadata( $attachment_id, $attachment_data );

		  if( 0 < intval( $attachment_id ) ) {
			return $attachment_id;
		  }
	  }

	  return false;
}

add_filter( 'sanitize_file_name', 'safir_special_chars' );
function safir_special_chars ( $filename ) {
	$search = array('Ç','ç','Ğ','ğ','ı','İ','Ö','ö','Ş','ş','Ü','ü',' ');
	$replace = array('c','c','g','g','i','i','o','o','s','s','u','u','-');
	$new = str_replace($search, $replace, $filename);
	return $new;
}


add_filter( 'wp_mail_content_type', 'set_content_type' );
function set_content_type( $content_type ) {
	return 'text/html';
}

// SafirNavi

	function safirnavi($pages = '', $range = 4) {
		 $showitems = ($range * 2)+1;

		 global $paged;
		 if(empty($paged)) $paged = 1;

		 if($pages == '')
		 {
			 global $wp_query;
			 $pages = $wp_query->max_num_pages;
			 if(!$pages)
			 {
				 $pages = 1;
			 }
		 }

		 if(1 != $pages)
		 {
			 echo "<div class=\"safirnavi\">";
			 if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo;</a>";
			 if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

			 for ($i=1; $i <= $pages; $i++)
			 {
				 if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
				 {
					 echo ($paged == $i)? "<span class=\"current\">".$i."</span>":"<a href='".get_pagenum_link($i)."' class=\"inactive\">".$i."</a>";
				 }
			 }

			 if ($paged < $pages && $showitems < $pages) echo "<a href=\"".get_pagenum_link($paged + 1)."\">&rsaquo;</a>";
			 if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>&raquo;</a>";
			 echo "</div>\n";
		 }
	}


// Admin Bar

	function remove_admin_bar()	{
		add_filter( 'show_admin_bar', '__return_false' );
		add_action( 'admin_print_scripts-profile.php', 'habfna_hide_admin_bar_settings' );
	}

	if((!current_user_can("administrator") && xoption("profileAdminBar"))) add_action('init', 'remove_admin_bar');

// Uploading

	function safir_upload_user_file( $file = array() ) {

		require_once( ABSPATH . 'wp-admin/includes/admin.php' );

	      $file_return = wp_handle_upload( $file, array('test_form' => false ) );

	      if( isset( $file_return['error'] ) || isset( $file_return['upload_error_handler'] ) ) {
	          return false;
	      } else {

	          $filename = $file_return['file'];

	          $attachment = array(
	              'post_mime_type' => $file_return['type'],
	              'post_title' => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),
	              'post_content' => '',
	              'post_status' => 'inherit',
	              'guid' => $file_return['url']
	          );

	          $attachment_id = wp_insert_attachment( $attachment, $file_return['url'] );

	          require_once(ABSPATH . 'wp-admin/includes/image.php');
	          $attachment_data = wp_generate_attachment_metadata( $attachment_id, $filename );
	          wp_update_attachment_metadata( $attachment_id, $attachment_data );

	          if( 0 < intval( $attachment_id ) ) {
	          	return $attachment_id;
	          }
	      }

	      return false;
	}

// Pagination
	function safirPaginationString($page = 1, $totalitems, $limit = 15, $adjacents = 1, $targetpage = "/", $pagestring = "?page=")
	{
		//defaults
		if(!$adjacents) $adjacents = 1;
		if(!$limit) $limit = 15;
		if(!$page) $page = 1;
		if(!$targetpage) $targetpage = "/";

		//other vars
		$prev = $page - 1;									//previous page is page - 1
		$next = $page + 1;									//next page is page + 1
		$lastpage = ceil($totalitems / $limit);				//lastpage is = total items / items per page, rounded up.
		$lpm1 = $lastpage - 1;								//last page minus 1

		/*
			Now we apply our rules and draw the pagination object.
			We're actually saving the code to a variable in case we want to draw it more than once.
		*/
		$pagination = "";
		if($lastpage > 1)
		{
			$pagination .= "<div class=\"safirnavi\"";
			$pagination .= ">";

			//previous button
			if ($page > 1)
				$pagination .= "<a href=\"$targetpage$pagestring$prev\">&lsaquo;</a>";
			else
				$pagination .= "<span class=\"disabled\">&lsaquo;</span>";

			//pages
			if ($lastpage < 7 + ($adjacents * 2))	//not enough pages to bother breaking it up
			{
				for ($counter = 1; $counter <= $lastpage; $counter++)
				{
					if ($counter == $page)
						$pagination .= "<span class=\"current\">$counter</span>";
					else
						$pagination .= "<a href=\"" . $targetpage . $pagestring . $counter . "\">$counter</a>";
				}
			}
			elseif($lastpage >= 7 + ($adjacents * 2))	//enough pages to hide some
			{
				//close to beginning; only hide later pages
				if($page < 1 + ($adjacents * 3))
				{
					for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
					{
						if ($counter == $page)
							$pagination .= "<span class=\"current\">$counter</span>";
						else
							$pagination .= "<a href=\"" . $targetpage . $pagestring . $counter . "\">$counter</a>";
					}
					$pagination .= "<span class=\"elipses\">...</span>";
					$pagination .= "<a href=\"" . $targetpage . $pagestring . $lpm1 . "\">$lpm1</a>";
					$pagination .= "<a href=\"" . $targetpage . $pagestring . $lastpage . "\">$lastpage</a>";
				}
				//in middle; hide some front and some back
				elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
				{
					$pagination .= "<a href=\"" . $targetpage . $pagestring . "1\">1</a>";
					$pagination .= "<a href=\"" . $targetpage . $pagestring . "2\">2</a>";
					$pagination .= "<span class=\"elipses\">...</span>";
					for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
					{
						if ($counter == $page)
							$pagination .= "<span class=\"current\">$counter</span>";
						else
							$pagination .= "<a href=\"" . $targetpage . $pagestring . $counter . "\">$counter</a>";
					}
					$pagination .= "<span class=\"elipses\">...</span>";
					$pagination .= "<a href=\"" . $targetpage . $pagestring . $lpm1 . "\">$lpm1</a>";
					$pagination .= "<a href=\"" . $targetpage . $pagestring . $lastpage . "\">$lastpage</a>";
				}
				//close to end; only hide early pages
				else
				{
					$pagination .= "<a href=\"" . $targetpage . $pagestring . "1\">1</a>";
					$pagination .= "<a href=\"" . $targetpage . $pagestring . "2\">2</a>";
					$pagination .= "<span class=\"elipses\">...</span>";
					for ($counter = $lastpage - (1 + ($adjacents * 3)); $counter <= $lastpage; $counter++)
					{
						if ($counter == $page)
							$pagination .= "<span class=\"current\">$counter</span>";
						else
							$pagination .= "<a href=\"" . $targetpage . $pagestring . $counter . "\">$counter</a>";
					}
				}
			}

			//next button
			if ($page < $counter - 1)
				$pagination .= "<a href=\"" . $targetpage . $pagestring . $next . "\">&rsaquo;</a>";
			else
				$pagination .= "<span class=\"disabled\">&rsaquo;</span>";
			$pagination .= "</div>\n";
		}

		return $pagination;

	}


function safir_set_transient( $id, $code, $time) {
	$homeURL = get_bloginfo("url");
	if(substr($homeURL, 0, 5) != "https") {
		$code = str_replace(str_replace("http://", "https://", $homeURL), $homeURL, $code);
	}
	set_transient( $id, $code, $time );
}


function file_get_contents_curl($url) {
	$ch = curl_init();

	curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);

	$data = curl_exec($ch);
	curl_close($ch);

	return $data;
}

// Js valid
add_filter('style_loader_tag', 'safir_remove_type_attr', 10, 2);
add_filter('script_loader_tag', 'safir_remove_type_attr', 10, 2);
function safir_remove_type_attr($tag, $handle) {
	return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
}

function disable_wp_emojicons() {
	remove_action( 'admin_print_styles', 'print_emoji_styles' );
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
}
add_action( 'init', 'disable_wp_emojicons' );


add_filter( 'get_the_archive_title', function ($title) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    }

    return $title;

});
