<div id="single">
<?php
$authorID = get_the_author_meta('ID');
$authorName = get_the_author_meta( 'display_name', $authorID );
$authorMail = get_the_author_meta( 'user_email', $authorID );
$authorBio = get_the_author_meta( 'user_description', $authorID );
$authorFacebook = get_the_author_meta( 'facebook', $authorID );
$authorTwitter = get_the_author_meta( 'twitter', $authorID );
$authorInstagram = get_the_author_meta( 'instagram', $authorID );
$authorLinkedin = get_the_author_meta( 'linkedin', $authorID );
$image = safir_get_author_image($authorID, 150);
?>

<div class="safirBox">

	<div class="pageHeading">
		<h1 class="title"><?php the_title(); ?></h1>
		<?php if(xoption('breadcrumb')) : ?>
			<div id="breadcrumb">
				<?php sfrBreadcrumbs(); ?>
			</div>
		<?php endif; ?>
	</div>

	<?php get_template_part('parts/metabox'); ?>

	<div class="authorBox single">
		<div class="thumb">
			<div class="image">
				<a href="<?php echo get_author_posts_url($authorID) ?>"><img src="<?php echo $image; ?>" width="140" height="140" alt="<?php echo $authorName ?>" /></a>
			</div>
		</div>
		<div class="detail">
			<div class="title">
				<a href="<?php echo get_author_posts_url($authorID) ?>">
					<?php echo $authorName ?>
				</a>
			</div>
			<div class="bio">
				<?php echo $authorBio ?>
			</div>
			<div class="share safirSocial">
				<ul>
					<?php if($authorFacebook) : ?>
						<li class="facebook">
							<a rel="external" href="<?php echo $authorFacebook ?>"></a>
						</li>
					<?php endif; ?>
					<?php if($authorTwitter) : ?>
						<li class="twitter">
							<a rel="external" href="<?php echo $authorTwitter ?>"></a>
						</li>
					<?php endif; ?>
					<?php if($authorInstagram) : ?>
						<li class="instagram">
							<a rel="external" href="<?php echo $authorInstagram ?>"></a>
						</li>
					<?php endif; ?>
					<?php if($authorLinkedin) : ?>
						<li class="linkedin">
							<a rel="external" href="<?php echo $authorLinkedin ?>"></a>
						</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	</div>

	<?php if(has_excerpt()) : ?>
		<div class="reading excerpt"><?php the_excerpt(); ?></div>
	<?php endif; ?>

	<div id="singleContent" class="reading">
		<?php the_content(); ?>
		<?php
		$attachments = '';
		for ($i=1; $i <= 5 ; $i++) {
			if($x = get_post_meta(get_the_ID(), 'haberresim' . $i, true)) {
				$attachments .= $x . ',';
			}
		}
		if($attachments) echo do_shortcode('[gallery ids='.$attachments.']')
		?>
	</div>

	<div id="page-links">
		<?php wp_link_pages(array('link_before'=>'<span>', 'link_after'=>'</span>', 'before'=>'')); ?>
	</div>

	<?php safirAd('singleAd3', 'ads singleAd3'); ?>

	<?php if(xoption("showTags")) :?>
		<?php if(has_tag()) : $tagTitle = __("ETİKETLER", "lara"); ?>
		<div class="tags">
			<?php the_tags('<span class="title">'.$tagTitle.':</span> ',', ',''); ?>
		</div>
		<?php endif; ?>
	<?php endif; ?>

</div>

<?php
// BENZER YAZILAR:
if(xoption('relatedCount') != 0) :
	include('lib/safirtema/relatedargs.php');
	$args['author'] = $authorID;
	$query = new wp_query($args);
	if($query->have_posts()) : ?>
		<div class="mainHeading stick margintop">
			<div class="safiricon icon icon61"></div>
			<div class="title"><?php _e("YAZARIN EKLEMİŞ OLDUĞU YAZILAR", "lara") ; ?></div>
		</div>

		<div class="safirBox" style="margin: 0">
			<div id="authorRelated">
				<?php while ($query->have_posts()) : $query->the_post(); ?>
					<div class="item">
						<div class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
						<div class="meta"><?php the_time('j F Y'); ?></div>
					</div>
				<?php endwhile; ?>
			</div>
			<?php safirnavi(); ?>
		</div>
		<?php
	endif;
endif;
wp_reset_postdata();
?>

<?php comments_template(); ?>

</div><!--single-->
