<?php
switch (get_post_meta(get_the_ID(), "galleryType", true)) {
	case 'type1':
	$galleryRedirect = false;
	break;

	case 'type2':
	$galleryRedirect = true;
	break;

	default:
	if(xoption("galleryType") == "type1") {
		$galleryRedirect = false;
	} else {
		$galleryRedirect = true;
	}
	break;
}

$hasPostGallery = false;
if($galleryRedirect) {
	$attachmentIDs = "";
	if (function_exists("has_block")) {
		$galleryPost = get_post(get_the_ID());
		$galleryContent = $galleryPost->post_content;
		$galleryDump = parse_blocks($galleryContent);
		foreach ($galleryDump as $block) {
			if($block['blockName'] == "core/gallery") {
				$text = $block['innerHTML'];
				preg_match_all('@data-id="(.*?)"@si', $text, $content);
				if(is_array($content[1])) $attachmentIDs = $content[1];
			}
		}
	}

	if(!is_array($attachmentIDs)) {
		$gallery = get_post_gallery( get_the_ID(), false );
		if($gallery) {
			$attachmentIDs = explode(',', $gallery['ids']);
		}
	}

	if(is_array($attachmentIDs)) $hasPostGallery = true;
}

if(xoption('skipToGallery') && $galleryRedirect && $hasPostGallery) :
	// Hit counts
	$postHit = get_post_meta(get_the_ID(), 'hit',true);
	if(is_numeric($postHit)) {
		$postHit++;
	} else {
		$postHit = 1;
	}
	update_post_meta(get_the_ID(), 'hit', $postHit);
	header('Location:' . get_the_permalink($attachmentIDs[0]));
	die();
endif;
?>
<?php get_header(); ?>
<?php while ( have_posts() ) : the_post(); ?>
<?php
// Hit counts
$postHit = get_post_meta($post->ID, 'hit',true);
if(is_numeric($postHit)) {
	$postHit++;
} else {
	$postHit = 1;
}
update_post_meta($post->ID, 'hit', $postHit);

$singlePart = "normal";
foreach(get_the_category() as $category) {
	if(get_option('slcode')) {
	if($category->term_id == xoption('photoCategory') || safir_top_category($category->term_id) == xoption('photoCategory')) { $singlePart = 'photo';	}
	if($category->term_id == xoption('videoCategory') || safir_top_category($category->term_id) == xoption('videoCategory')) { $singlePart = 'video';	}
	if($category->term_id == xoption('articleCategory') || safir_top_category($category->term_id) == xoption('articleCategory')) { $singlePart = 'article';	}
	}
}

switch ($singlePart) {
	case 'normal':
		get_template_part('single-normal');
		get_sidebar('single');
	break;

	case 'photo':
	case 'video':
		get_template_part('single-normal');
		get_sidebar($singlePart);
	break;

	case 'article':
		get_template_part('single-article');
		get_sidebar('article');
	break;
}

endwhile;
?>
<?php get_footer(); ?>
