<?php
if($offset == 0) $offset = 1;

$queryargs = array(
	'posts_per_page' => $number,
	'post_status' => 'publish',
	'no_found_rows' => true,
	'ignore_sticky_posts' => true,
	'offset' => $offset-1,
	'tag' => $tags,
);

$category = "";
$doCategoryCache = true;
switch ($categoryChoice) {
	case 'all':
		$category = "0";
	break;
	case 'include':
		if(is_array($catIDs)) {
			foreach ($catIDs as $catID) {
				$category .= $catID . ',';
			}
		} else {
			$category = "0";
			$catIDs = array();
		}
		if( isset($allLink) && count($catIDs) == 1 ) :
			$allLinkCategory = get_category_link($catIDs[0]);
		endif;
	break;
	case 'exclude':
		if(is_array($catIDs)) {
			foreach ($catIDs as $catID) {
				$category .= '-' . $catID . ',';
			}
		} else {
			$category = "0";
		}
	break;
	case 'current':
		if(is_category()) {
			$category = get_query_var('cat');
		}
		if(is_single()) {
			foreach(get_the_category() as $cat) {
				if( $category != "" ) { $category .= ","; }
				$category .= $cat->cat_ID;
			}
			$queryargs['post__not_in'] = array(get_the_ID());
		}
		if(is_attachment()) {
			global $post;
			foreach(get_the_category($post->post_parent) as $cat) {
				if( $category != "" ) { $category .= ","; }
				$category .= $cat->cat_ID;
			}
			$queryargs['post__not_in'] = array(array($post->post_parent));
		}
		$doCategoryCache = false;
	break;
}
$queryargs['cat'] = $category;


switch($timeFilter) {
	case 'all': break;
	case 'year':
		$queryargs['year'] = date('Y');
	break;
	case 'month':
		$queryargs['year'] = date('Y');
		$queryargs['monthnum'] = date('n');
	break;
	case 'week':
		$queryargs['year'] = date('Y');
		$queryargs['w'] = date('W');
	break;
	case 'today':
		$queryargs['year'] = date('Y');
		$queryargs['monthnum'] = date('n');
		$queryargs['day'] = date('j');
	break;
}

switch($filter) {
	case "hit":
		if(function_exists('the_views')) {
			$field = 'views';
		} else {
			$field = 'hit';
		}
		$queryargs['meta_key'] = $field;
		$queryargs['orderby'] = 'meta_value_num';
		$queryargs['order'] = 'DESC';
		$doCategoryCache = false;
	break;
	case "rand":
	case "date":
	case "comment_count":
		$queryargs['orderby'] = $filter;
	break;
}

$doCache = false;
if($doCategoryCache && $filter != 'rand' && $filter != 'hit') $doCache = true;
