<?php
if($offset == 0) $offset = 1;

$queryargs = array(
	'posts_per_page' => $number,
	'post_status' => 'publish',
	'no_found_rows' => true,
	'ignore_sticky_posts' => true,
	'offset' => $offset-1,
	'tag' => $tags,
);

switch($timeFilter) {
	case 'all': break;
	case 'year':
		$queryargs['year'] = date('Y');
	break;
	case 'month':
		$queryargs['year'] = date('Y');
		$queryargs['monthnum'] = date('n');
	break;
	case 'week':
		$queryargs['year'] = date('Y');
		$queryargs['w'] = date('W');
	break;
	case 'today':
		$queryargs['year'] = date('Y');
		$queryargs['monthnum'] = date('n');
		$queryargs['day'] = date('j');
	break;
}

switch($filter) {
	case "hit":
		if(function_exists('the_views')) {
			$field = 'views';
		} else {
			$field = 'hit';
		}
		$queryargs['meta_key'] = $field;
		$queryargs['orderby'] = 'meta_value_num';
		$queryargs['order'] = 'DESC';
	break;
	case "rand":
	case "date":
	case "comment_count":
		$queryargs['orderby'] = $filter;
	break;
}

$doCache = false;
if($filter != 'rand' && $filter != 'hit') $doCache = true;
